/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class GlobalModulesDefinition {
    public static final String NAME = "name";
    public static final String SLOT = "slot";
    public static final String ANNOTATIONS = "annotations";
    public static final String META_INF = "meta-inf";
    public static final String SERVICES = "services";
    public static final String GLOBAL_MODULES = "global-modules";
    public static final String DEFAULT_SLOT = "main";
    public static final SimpleAttributeDefinition NAME_AD = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).build();
    public static final SimpleAttributeDefinition SLOT_AD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("slot", ModelType.STRING, true).setDefaultValue(new ModelNode("main"))).build();
    public static final SimpleAttributeDefinition ANNOTATIONS_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("annotations", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    public static final SimpleAttributeDefinition SERVICES_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("services", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.FALSE)).build();
    public static final SimpleAttributeDefinition META_INF_AD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("meta-inf", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(ModelNode.TRUE)).build();
    private static final SimpleAttributeDefinition[] VALUE_TYPE_FIELDS = new SimpleAttributeDefinition[]{NAME_AD, SLOT_AD, ANNOTATIONS_AD, SERVICES_AD, META_INF_AD};
    private static final AttributeMarshaller VALUE_TYPE_MARSHALLER = new AttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (resourceModel.isDefined()) {
                writer.writeEmptyElement(Element.MODULE.getLocalName());
                for (SimpleAttributeDefinition valueType : VALUE_TYPE_FIELDS) {
                    valueType.getMarshaller().marshall((AttributeDefinition)valueType, resourceModel, true, writer);
                }
            }
        }
    };
    private static final ObjectTypeAttributeDefinition VALUE_TYPE_AD = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"module", (AttributeDefinition[])VALUE_TYPE_FIELDS).setAttributeMarshaller(VALUE_TYPE_MARSHALLER)).build();
    private static final ParameterCorrector DUPLICATE_CORRECTOR = new ParameterCorrector(){

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            ModelNode result = null;
            if (newValue.isDefined()) {
                ArrayList<ModelNode> elementSet = new ArrayList<ModelNode>();
                LinkedHashSet<CallSite> identifierSet = new LinkedHashSet<CallSite>();
                List asList = newValue.asList();
                for (int i = asList.size() - 1; i >= 0; --i) {
                    ModelNode slot;
                    ModelNode element = (ModelNode)asList.get(i);
                    ModelNode name = element.get(GlobalModulesDefinition.NAME);
                    if (!identifierSet.add((CallSite)((Object)(name + ":" + (slot = element.get(GlobalModulesDefinition.SLOT)))))) {
                        EeLogger.ROOT_LOGGER.debugf("Removing duplicate entry %s from %s attribute %s", element.toString(), GlobalModulesDefinition.GLOBAL_MODULES);
                        continue;
                    }
                    elementSet.add(element);
                }
                if (!elementSet.isEmpty()) {
                    Collections.reverse(elementSet);
                    result = new ModelNode();
                    for (ModelNode element : elementSet) {
                        result.add(element);
                    }
                }
            }
            return result == null ? newValue : result;
        }
    };
    public static final AttributeDefinition INSTANCE = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"global-modules", (ObjectTypeAttributeDefinition)VALUE_TYPE_AD).setRequired(false)).setCorrector(DUPLICATE_CORRECTOR)).build();

    public static List<GlobalModule> createModuleList(OperationContext context, ModelNode globalMods) throws OperationFailedException {
        ArrayList<GlobalModule> ret = new ArrayList<GlobalModule>();
        if (globalMods.isDefined()) {
            for (ModelNode module : globalMods.asList()) {
                String name = NAME_AD.resolveModelAttribute(context, module).asString();
                String slot = SLOT_AD.resolveModelAttribute(context, module).asString();
                boolean annotations = ANNOTATIONS_AD.resolveModelAttribute(context, module).asBoolean();
                boolean services = SERVICES_AD.resolveModelAttribute(context, module).asBoolean();
                boolean metaInf = META_INF_AD.resolveModelAttribute(context, module).asBoolean();
                ret.add(new GlobalModule(ModuleIdentifierUtil.canonicalModuleIdentifier((String)name, (String)slot), annotations, services, metaInf));
            }
        }
        return ret;
    }

    public static final class GlobalModule {
        private final String moduleName;
        private final boolean annotations;
        private final boolean services;
        private final boolean metaInf;

        GlobalModule(String moduleName, boolean annotations, boolean services, boolean metaInf) {
            this.moduleName = moduleName;
            this.annotations = annotations;
            this.services = services;
            this.metaInf = metaInf;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public boolean isAnnotations() {
            return this.annotations;
        }

        public boolean isServices() {
            return this.services;
        }

        public boolean isMetaInf() {
            return this.metaInf;
        }
    }
}

