/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing.api;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.resteasy.tracing.api.RESTEasyTracingInfoFormat;
import org.jboss.resteasy.tracing.api.RESTEasyTracingMessage;
import org.jboss.resteasy.tracing.api.providers.TextBasedRESTEasyTracingInfo;

public abstract class RESTEasyTracingInfo {
    protected static final ServiceLoader<RESTEasyTracingInfo> INSTANCES;
    protected static final RESTEasyTracingInfo DEFAULT;
    private final List<RESTEasyTracingMessage> messageQueue = new ArrayList<RESTEasyTracingMessage>();

    public static RESTEasyTracingInfo get(String format) {
        if (format == null || format.isEmpty()) {
            return DEFAULT;
        }
        if (format.equals(RESTEasyTracingInfoFormat.TEXT.toString())) {
            return new TextBasedRESTEasyTracingInfo();
        }
        if (format.equals(RESTEasyTracingInfoFormat.JSON.toString())) {
            for (RESTEasyTracingInfo instance : INSTANCES) {
                if (!instance.supports(RESTEasyTracingInfoFormat.JSON)) continue;
                return instance;
            }
        }
        return DEFAULT;
    }

    public abstract boolean supports(RESTEasyTracingInfoFormat var1);

    public abstract String[] getMessages();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMessage(RESTEasyTracingMessage message) {
        List<RESTEasyTracingMessage> list = this.messageQueue;
        synchronized (list) {
            this.messageQueue.add(message);
        }
    }

    public abstract String formatDuration(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isEmpty() {
        List<RESTEasyTracingMessage> list = this.messageQueue;
        synchronized (list) {
            return this.messageQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int size() {
        List<RESTEasyTracingMessage> list = this.messageQueue;
        synchronized (list) {
            return this.messageQueue.size();
        }
    }

    protected final List<RESTEasyTracingMessage> pop() {
        List<RESTEasyTracingMessage> list = this.messageQueue;
        synchronized (list) {
            List<RESTEasyTracingMessage> list2;
            try {
                list2 = List.copyOf(this.messageQueue);
                this.messageQueue.clear();
            }
            catch (Throwable throwable) {
                this.messageQueue.clear();
                throw throwable;
            }
            return list2;
        }
    }

    static {
        DEFAULT = new TextBasedRESTEasyTracingInfo();
        INSTANCES = ServiceLoader.load(RESTEasyTracingInfo.class, Thread.currentThread().getContextClassLoader());
    }
}

