/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.sso.hotrod;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.jboss.as.controller.ServiceNameFactory;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.clustering.infinispan.client.service.RemoteCacheConfigurationServiceInstallerFactory;
import org.wildfly.clustering.infinispan.client.service.RemoteCacheServiceInstallerFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.session.infinispan.remote.user.HotRodUserManagerFactory;
import org.wildfly.clustering.web.service.user.DistributableUserManagementProvider;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class HotRodUserManagementProvider
implements DistributableUserManagementProvider {
    private static final String DEFAULT_CONFIGURATION = "{\n    \"distributed-cache\": {\n        \"mode\" : \"SYNC\",\n        \"transaction\" : {\n            \"mode\" : \"NON_XA\",\n            \"locking\" : \"PESSIMISTIC\"\n        }\n    }\n}";
    private final BinaryServiceConfiguration configuration;

    public HotRodUserManagementProvider(BinaryServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public Iterable<ServiceInstaller> getServiceInstallers(String name) {
        final String templateName = this.configuration.getChildName();
        Consumer<RemoteCacheConfigurationBuilder> configurator = new Consumer<RemoteCacheConfigurationBuilder>(){

            @Override
            public void accept(RemoteCacheConfigurationBuilder builder) {
                builder.forceReturnValues(false).nearCacheMode(NearCacheMode.DISABLED).transactionMode(TransactionMode.NONE);
                if (templateName != null) {
                    builder.templateName(templateName);
                } else {
                    builder.configuration(HotRodUserManagementProvider.DEFAULT_CONFIGURATION);
                }
            }
        };
        BinaryServiceConfiguration configuration = this.configuration.withChildName(name);
        ServiceInstaller configurationInstaller = new RemoteCacheConfigurationServiceInstallerFactory((Consumer)configurator).apply(configuration);
        ServiceInstaller cacheInstaller = RemoteCacheServiceInstallerFactory.INSTANCE.apply(configuration);
        final ServiceDependency cache = configuration.getServiceDependency(HotRodServiceDescriptor.REMOTE_CACHE);
        RemoteCacheConfiguration cacheConfiguration = new RemoteCacheConfiguration(){

            public <K, V> RemoteCache<K, V> getCache() {
                return (RemoteCache)cache.get();
            }
        };
        ServiceInstaller installer = (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(HotRodUserManagerFactory::new, (Supplier)Functions.constantSupplier((Object)cacheConfiguration)).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)DistributableUserManagementProvider.USER_MANAGER_FACTORY, (String)name))).requires((Consumer)cache)).build();
        return List.of(configurationInstaller, cacheInstaller, installer);
    }
}

