/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.sso.infinispan;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.controller.ServiceNameFactory;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.infinispan.service.CacheConfigurationServiceInstaller;
import org.wildfly.clustering.infinispan.service.CacheServiceInstaller;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.session.infinispan.embedded.user.InfinispanUserManagerFactory;
import org.wildfly.clustering.web.service.user.DistributableUserManagementProvider;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class InfinispanUserManagementProvider
implements DistributableUserManagementProvider {
    private final BinaryServiceConfiguration configuration;

    public InfinispanUserManagementProvider(BinaryServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public Iterable<ServiceInstaller> getServiceInstallers(String name) {
        BinaryServiceConfiguration configuration = this.configuration.withChildName(name);
        CacheConfigurationServiceInstaller configurationInstaller = new CacheConfigurationServiceInstaller(configuration, CacheConfigurationServiceInstaller.fromTemplate((BinaryServiceConfiguration)this.configuration));
        CacheServiceInstaller cacheInstaller = new CacheServiceInstaller(configuration);
        final ServiceDependency cache = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        EmbeddedCacheConfiguration cacheConfiguration = new EmbeddedCacheConfiguration(){

            public <K, V> Cache<K, V> getCache() {
                return (Cache)cache.get();
            }
        };
        ServiceInstaller installer = (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(InfinispanUserManagerFactory::new, (Supplier)Functions.constantSupplier((Object)cacheConfiguration)).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)DistributableUserManagementProvider.USER_MANAGER_FACTORY, (String)name))).requires((Consumer)cache)).build();
        return List.of(configurationInstaller, cacheInstaller, installer);
    }
}

