/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.resourceadapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;

public class ActivationImpl
implements Activation {
    private static final long serialVersionUID = 1L;
    protected final TransactionSupportEnum transactionSupport;
    protected final Map<String, String> configProperties;
    protected final List<AdminObject> adminObjects;
    protected final List<ConnectionDefinition> connectionDefinitions;
    protected final List<String> beanValidationGroups;
    protected final String bootstrapContext;
    protected final String archive;
    protected final String id;
    protected WorkManager workmanager;

    public ActivationImpl(String id, String archive, TransactionSupportEnum transactionSupport, List<ConnectionDefinition> connectionDefinitions, List<AdminObject> adminObjects, Map<String, String> configProperties, List<String> beanValidationGroups, String bootstrapContext, WorkManager workmanager) {
        this.id = id;
        this.archive = archive;
        this.transactionSupport = transactionSupport;
        if (connectionDefinitions != null) {
            this.connectionDefinitions = new ArrayList<ConnectionDefinition>(connectionDefinitions.size());
            this.connectionDefinitions.addAll(connectionDefinitions);
        } else {
            this.connectionDefinitions = null;
        }
        if (adminObjects != null) {
            this.adminObjects = new ArrayList<AdminObject>(adminObjects.size());
            this.adminObjects.addAll(adminObjects);
        } else {
            this.adminObjects = null;
        }
        if (configProperties != null) {
            this.configProperties = new HashMap<String, String>(configProperties.size());
            this.configProperties.putAll(configProperties);
        } else {
            this.configProperties = null;
        }
        if (beanValidationGroups != null) {
            this.beanValidationGroups = new ArrayList<String>(beanValidationGroups.size());
            this.beanValidationGroups.addAll(beanValidationGroups);
        } else {
            this.beanValidationGroups = null;
        }
        this.bootstrapContext = bootstrapContext;
        this.workmanager = workmanager;
    }

    public TransactionSupportEnum getTransactionSupport() {
        return this.transactionSupport;
    }

    public List<ConnectionDefinition> getConnectionDefinitions() {
        if (this.connectionDefinitions == null) {
            return null;
        }
        return Collections.unmodifiableList(this.connectionDefinitions);
    }

    public List<AdminObject> getAdminObjects() {
        return this.adminObjects == null ? null : Collections.unmodifiableList(this.adminObjects);
    }

    public Map<String, String> getConfigProperties() {
        return this.configProperties == null ? null : Collections.unmodifiableMap(this.configProperties);
    }

    public List<String> getBeanValidationGroups() {
        return this.beanValidationGroups == null ? null : Collections.unmodifiableList(this.beanValidationGroups);
    }

    public String getBootstrapContext() {
        return this.bootstrapContext;
    }

    public String getId() {
        return this.id;
    }

    public String getArchive() {
        return this.archive;
    }

    public WorkManager getWorkManager() {
        return this.workmanager;
    }

    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminObjects == null ? 0 : this.adminObjects.hashCode());
        result = 31 * result + (this.beanValidationGroups == null ? 0 : this.beanValidationGroups.hashCode());
        result = 31 * result + (this.bootstrapContext == null ? 0 : this.bootstrapContext.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.connectionDefinitions == null ? 0 : this.connectionDefinitions.hashCode());
        result = 31 * result + (this.transactionSupport == null ? 0 : this.transactionSupport.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.archive == null ? 0 : this.archive.hashCode());
        result = 31 * result + (this.workmanager == null ? 0 : this.workmanager.hashCode());
        return result;
    }

    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivationImpl)) {
            return false;
        }
        ActivationImpl other = (ActivationImpl)obj;
        if (this.adminObjects == null ? other.adminObjects != null : !this.adminObjects.equals(other.adminObjects)) {
            return false;
        }
        if (this.beanValidationGroups == null ? other.beanValidationGroups != null : !this.beanValidationGroups.equals(other.beanValidationGroups)) {
            return false;
        }
        if (this.bootstrapContext == null ? other.bootstrapContext != null : !this.bootstrapContext.equals(other.bootstrapContext)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        if (this.connectionDefinitions == null ? other.connectionDefinitions != null : !this.connectionDefinitions.equals(other.connectionDefinitions)) {
            return false;
        }
        if (this.transactionSupport != other.transactionSupport) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.archive == null ? other.archive != null : !this.archive.equals(other.archive)) {
            return false;
        }
        return !(this.workmanager == null ? other.workmanager != null : !this.workmanager.equals((Object)other.workmanager));
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(1024);
        if (this.archive != null) {
            sb.append("<resource-adapter");
        } else {
            sb.append("<ironjacamar");
        }
        if (this.id != null) {
            sb.append(" ").append(Activation.Attribute.ID).append("=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.archive != null) {
            sb.append("<").append(Activation.Tag.ARCHIVE).append(">");
            sb.append(this.archive);
            sb.append("</").append(Activation.Tag.ARCHIVE).append(">");
        }
        if (this.beanValidationGroups != null && this.beanValidationGroups.size() > 0) {
            sb.append("<").append(Activation.Tag.BEAN_VALIDATION_GROUPS).append(">");
            for (String bvg : this.beanValidationGroups) {
                sb.append("<").append(Activation.Tag.BEAN_VALIDATION_GROUP).append(">");
                sb.append(bvg);
                sb.append("</").append(Activation.Tag.BEAN_VALIDATION_GROUP).append(">");
            }
            sb.append("</").append(Activation.Tag.BEAN_VALIDATION_GROUPS).append(">");
        }
        if (this.bootstrapContext != null) {
            sb.append("<").append(Activation.Tag.BOOTSTRAP_CONTEXT).append(">");
            sb.append(this.bootstrapContext);
            sb.append("</").append(Activation.Tag.BOOTSTRAP_CONTEXT).append(">");
        }
        if (this.configProperties != null && this.configProperties.size() > 0) {
            for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
                sb.append("<").append(Activation.Tag.CONFIG_PROPERTY);
                sb.append(" name=\"").append(entry.getKey()).append("\">");
                sb.append(entry.getValue());
                sb.append("</").append(Activation.Tag.CONFIG_PROPERTY).append(">");
            }
        }
        if (this.transactionSupport != null) {
            sb.append("<").append(Activation.Tag.TRANSACTION_SUPPORT).append(">");
            sb.append(this.transactionSupport);
            sb.append("</").append(Activation.Tag.TRANSACTION_SUPPORT).append(">");
        }
        if (this.workmanager != null) {
            sb.append(this.workmanager);
        }
        if (this.connectionDefinitions != null && this.connectionDefinitions.size() > 0) {
            sb.append("<").append(Activation.Tag.CONNECTION_DEFINITIONS).append(">");
            for (ConnectionDefinition cd : this.connectionDefinitions) {
                sb.append(cd);
            }
            sb.append("</").append(Activation.Tag.CONNECTION_DEFINITIONS).append(">");
        }
        if (this.adminObjects != null && this.adminObjects.size() > 0) {
            sb.append("<").append(Activation.Tag.ADMIN_OBJECTS).append(">");
            for (AdminObject ao : this.adminObjects) {
                sb.append(ao);
            }
            sb.append("</").append(Activation.Tag.ADMIN_OBJECTS).append(">");
        }
        if (this.archive != null) {
            sb.append("</resource-adapter>");
        } else {
            sb.append("</ironjacamar>");
        }
        return sb.toString();
    }
}

