/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;

public interface BinaryOperator<T>
extends java.util.function.BinaryOperator<T>,
BiFunction<T, T, T> {
    public static final BinaryOperator<?> FORMER_IDENTITY = (value1, value2) -> value1;
    public static final BinaryOperator<?> LATTER_IDENTITY = (value1, value2) -> value2;
    public static final BinaryOperator<?> NULL = (value1, value2) -> null;

    default public BinaryOperator<T> compose(final UnaryOperator<T> before1, final UnaryOperator<T> before2) {
        return new BinaryOperator<T>(this){
            final /* synthetic */ BinaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value1, T value2) {
                return this.this$0.apply(before1.apply(value1), before2.apply(value2));
            }
        };
    }

    default public BinaryOperator<T> andThen(final UnaryOperator<T> after) {
        return new BinaryOperator<T>(this){
            final /* synthetic */ BinaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value1, T value2) {
                return after.apply(this.this$0.apply(value1, value2));
            }
        };
    }

    default public BinaryOperator<T> reverse() {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T value2, T value1) {
                return BinaryOperator.this.apply(value1, value2);
            }
        };
    }

    default public BinaryOperator<T> withDefault(final Predicate<T> predicate1, final java.util.function.Supplier<T> defaultValue1, final Predicate<T> predicate2, final java.util.function.Supplier<T> defaultValue2) {
        return new BinaryOperator<T>(this){
            final /* synthetic */ BinaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value1, T value2) {
                return this.this$0.apply(predicate1.test(value1) ? value1 : defaultValue1.get(), predicate2.test(value2) ? value2 : defaultValue2.get());
            }
        };
    }

    default public BinaryOperator<T> orDefault(final BiPredicate<T, T> predicate, final java.util.function.Supplier<T> defaultResult) {
        return new BinaryOperator<T>(this){
            final /* synthetic */ BinaryOperator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T apply(T value1, T value2) {
                return predicate.test(value1, value2) ? this.this$0.apply(value1, value2) : defaultResult.get();
            }
        };
    }

    public static <T> BinaryOperator<T> former() {
        return FORMER_IDENTITY;
    }

    public static <T> BinaryOperator<T> latter() {
        return LATTER_IDENTITY;
    }

    public static <T> BinaryOperator<T> empty() {
        return NULL;
    }

    public static <T> BinaryOperator<T> of(T result) {
        return result != null ? BinaryOperator.get(Supplier.of(result)) : BinaryOperator.empty();
    }

    public static <T> BinaryOperator<T> get(final java.util.function.Supplier<T> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new BinaryOperator<T>(){

            @Override
            public T apply(T ignore1, T ignore2) {
                return supplier.get();
            }
        } : BinaryOperator.empty();
    }

    public static <T> BinaryOperator<T> apply(final java.util.function.BiFunction<? super T, ? super T, T> function) {
        return function != null && function != Function.NULL ? new BinaryOperator<T>(){

            @Override
            public T apply(T value1, T value2) {
                return function.apply(value1, value2);
            }
        } : BinaryOperator.empty();
    }

    public static <T> BinaryOperator<T> applyFormer(final UnaryOperator<T> operator) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T value, T ignored) {
                return operator.apply(value);
            }
        };
    }

    public static <T> BinaryOperator<T> applyLatter(final UnaryOperator<T> operator) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T ignored, T value) {
                return operator.apply(value);
            }
        };
    }
}

