/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.Consumer;

public interface DoubleConsumer
extends java.util.function.DoubleConsumer {
    public static final DoubleConsumer EMPTY = value -> {};

    @Override
    default public DoubleConsumer andThen(final java.util.function.DoubleConsumer after) {
        return new DoubleConsumer(){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(double value) {
                this.this$0.accept(value);
                after.accept(value);
            }
        };
    }

    default public Consumer<Double> boxed() {
        return this.compose(Double::doubleValue);
    }

    default public DoubleConsumer when(final DoublePredicate predicate) {
        return new DoubleConsumer(){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(double value) {
                if (predicate.test(value)) {
                    this.this$0.accept(value);
                }
            }
        };
    }

    default public DoubleConsumer withDefault(final DoublePredicate predicate, final DoubleSupplier defaultValue) {
        return new DoubleConsumer(){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(double value) {
                this.this$0.accept(predicate.test(value) ? value : defaultValue.getAsDouble());
            }
        };
    }

    default public DoubleConsumer composeAsDouble(final DoubleUnaryOperator composer) {
        return new DoubleConsumer(){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(double value) {
                this.this$0.accept(composer.applyAsDouble(value));
            }
        };
    }

    default public <V> Consumer<V> compose(final ToDoubleFunction<V> composer) {
        return new Consumer<V>(this){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(V value) {
                this.this$0.accept(composer.applyAsDouble(value));
            }
        };
    }

    default public <V1, V2> BiConsumer<V1, V2> compose(final ToDoubleBiFunction<V1, V2> composer) {
        return new BiConsumer<V1, V2>(this){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(V1 value1, V2 value2) {
                this.this$0.accept(composer.applyAsDouble(value1, value2));
            }
        };
    }

    default public <R> DoubleFunction<R> thenReturn(final Supplier<R> factory) {
        return new DoubleFunction<R>(this){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public R apply(double value) {
                this.this$0.accept(value);
                return factory.get();
            }
        };
    }

    default public DoubleUnaryOperator thenReturnDouble(final DoubleSupplier factory) {
        return new DoubleUnaryOperator(){
            final /* synthetic */ DoubleConsumer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public double applyAsDouble(double value) {
                this.this$0.accept(value);
                return factory.getAsDouble();
            }
        };
    }

    public static DoubleConsumer acceptAll(final Iterable<? extends DoubleConsumer> consumers) {
        return new DoubleConsumer(){

            @Override
            public void accept(double value) {
                for (DoubleConsumer consumer : consumers) {
                    consumer.accept(value);
                }
            }
        };
    }
}

