/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.interceptors.LoggingInterceptor;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

class ExceptionLoggingWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    static final ExceptionLoggingWriteHandler INSTANCE = new ExceptionLoggingWriteHandler();

    private ExceptionLoggingWriteHandler() {
        super(new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS});
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updateOrCreateDefaultExceptionLoggingEnabledService(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updateOrCreateDefaultExceptionLoggingEnabledService(context, restored);
    }

    void updateOrCreateDefaultExceptionLoggingEnabledService(OperationContext context, ModelNode model) throws OperationFailedException {
        boolean enabled = EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS.resolveModelAttribute(context, model).asBoolean();
        ServiceName serviceName = LoggingInterceptor.LOGGING_ENABLED_SERVICE_NAME;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController sc = registry.getService(serviceName);
        if (sc != null) {
            AtomicBoolean value = (AtomicBoolean)sc.getValue();
            value.set(enabled);
        } else {
            ServiceBuilder sb = context.getServiceTarget().addService(serviceName);
            sb.setInstance((org.jboss.msc.Service)new ValueService(new AtomicBoolean(enabled))).install();
        }
    }

    private static final class ValueService
    implements Service<AtomicBoolean> {
        private final AtomicBoolean value;

        public ValueService(AtomicBoolean value) {
            this.value = value;
        }

        public void start(StartContext context) {
        }

        public void stop(StopContext context) {
        }

        public AtomicBoolean getValue() throws IllegalStateException {
            return this.value;
        }
    }
}

