/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.distributable;

import jakarta.ejb.EJBException;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.TimerConfig;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.timerservice.distributable.DistributableTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.distributable.OOBTimer;
import org.jboss.as.ejb3.timerservice.distributable.SimpleImmutableScheduleExpression;
import org.jboss.as.ejb3.timerservice.distributable.TimerSynchronizationFactory;
import org.jboss.as.ejb3.timerservice.spi.AutoTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;
import org.jboss.invocation.InterceptorContext;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.service.DecoratedService;

public class DistributableTimerService<I>
extends DecoratedService
implements ManagedTimerService {
    private final TimerServiceRegistry registry;
    private final TimedObjectInvoker invoker;
    private final TimerManager<I> manager;
    private final TimerSynchronizationFactory<I> synchronizationFactory;
    private final Function<String, I> identifierParser;
    private final Predicate<TimerConfig> filter;

    public DistributableTimerService(DistributableTimerServiceConfiguration<I> configuration, TimerManager<I> manager) {
        super(manager);
        this.invoker = configuration.getInvoker();
        this.identifierParser = configuration.getIdentifierParser();
        this.filter = configuration.getTimerFilter();
        this.registry = configuration.getTimerServiceRegistry();
        this.manager = manager;
        this.synchronizationFactory = configuration.getTimerSynchronizationFactory();
        Supplier identifierFactory = this.manager.getIdentifierFactory();
        EJBComponent component = this.invoker.getComponent();
        try (Batch batch = (Batch)this.manager.getBatchFactory().get();){
            for (Map.Entry<Method, List<AutoTimer>> entry : component.getComponentDescription().getScheduleMethods().entrySet()) {
                Method method = entry.getKey();
                ListIterator<AutoTimer> timers = entry.getValue().listIterator();
                while (timers.hasNext()) {
                    AutoTimer autoTimer = timers.next();
                    if (!this.filter.test(autoTimer.getTimerConfig())) continue;
                    this.manager.createTimer(identifierFactory.get(), (ScheduleTimerConfiguration)new SimpleScheduleTimerConfiguration(autoTimer.getScheduleExpression()), (Object)autoTimer.getTimerConfig().getInfo(), method, timers.previousIndex());
                }
            }
        }
        this.registry.registerTimerService(this);
    }

    @Override
    public TimedObjectInvoker getInvoker() {
        return this.invoker;
    }

    @Override
    public void close() {
        this.manager.close();
        this.registry.unregisterTimerService(this);
    }

    @Override
    public ManagedTimer findTimer(String timerId) {
        OOBTimer<Object> oOBTimer;
        block9: {
            ManagedTimer currentTimer;
            InterceptorContext interceptorContext = CurrentInvocationContext.get();
            ManagedTimer managedTimer = currentTimer = interceptorContext != null ? (ManagedTimer)interceptorContext.getTimer() : null;
            if (currentTimer != null && currentTimer.getId().equals(timerId)) {
                return currentTimer;
            }
            I id = this.identifierParser.apply(timerId);
            Batch batch = (Batch)this.manager.getBatchFactory().get();
            try {
                Timer timer = this.manager.getTimer(id);
                OOBTimer<Object> oOBTimer2 = oOBTimer = timer != null ? new OOBTimer<Object>(this.manager, timer.getId(), this.invoker, this.synchronizationFactory) : null;
                if (batch == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (batch != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            batch.close();
        }
        return oOBTimer;
    }

    public jakarta.ejb.Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig config) {
        return this.createEJBTimer(new ScheduleTimerFactory(schedule, config.getInfo()));
    }

    public jakarta.ejb.Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig config) {
        return this.createEJBTimer(new IntervalTimerFactory(initialExpiration.toInstant(), Duration.ofMillis(intervalDuration), config.getInfo()));
    }

    public jakarta.ejb.Timer createSingleActionTimer(Date expiration, TimerConfig config) {
        return this.createEJBTimer(new IntervalTimerFactory(expiration.toInstant(), null, config.getInfo()));
    }

    private jakarta.ejb.Timer createEJBTimer(BiFunction<TimerManager<I>, I, Timer<I>> factory) {
        Timer<I> timer = this.createTimer(factory);
        return new OOBTimer<Object>(this.manager, timer.getId(), this.invoker, this.synchronizationFactory);
    }

    private Timer<I> createTimer(BiFunction<TimerManager<I>, I, Timer<I>> factory) {
        Transaction transaction = ManagedTimerService.getActiveTransaction();
        SuspendedBatch suspended = ((Batch)this.manager.getBatchFactory().get()).suspend();
        try (Context context = suspended.resumeWithContext();){
            Timer<I> timer;
            block17: {
                Batch batch = (Batch)context.get();
                try {
                    Object id = this.manager.getIdentifierFactory().get();
                    Timer<I> timer2 = factory.apply(this.manager, id);
                    if (timer2.getMetaData().getNextTimeout() != null) {
                        if (transaction != null) {
                            this.registerSynchronization(transaction, timer2);
                            TransactionSynchronizationRegistry tsr = this.invoker.getComponent().getTransactionSynchronizationRegistry();
                            tsr.putResource(id, new AbstractMap.SimpleImmutableEntry<Timer<I>, SuspendedBatch>(timer2, suspended));
                            TreeSet<Object> inactiveTimers = (TreeSet<Object>)tsr.getResource(this.manager);
                            if (inactiveTimers == null) {
                                inactiveTimers = new TreeSet<Object>();
                                tsr.putResource(this.manager, inactiveTimers);
                            }
                            inactiveTimers.add(id);
                        } else {
                            this.synchronizationFactory.getActivateTask().accept(timer2);
                        }
                    } else {
                        timer2.cancel();
                    }
                    timer = timer2;
                    if (batch == null) break block17;
                }
                catch (Throwable throwable) {
                    if (batch != null) {
                        try {
                            batch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                batch.close();
            }
            return timer;
        }
    }

    private void registerSynchronization(Transaction transaction, Timer<I> timer) {
        Batch batch = (Batch)this.manager.getBatchFactory().get();
        try (Context context = batch.suspendWithContext();){
            transaction.registerSynchronization(this.synchronizationFactory.createActivateSynchronization(timer, (SuspendedBatch)context.get()));
        }
        catch (RollbackException | SystemException e) {
            batch.close();
            throw new EJBException((Exception)e);
        }
    }

    public Collection<jakarta.ejb.Timer> getTimers() throws EJBException {
        Set inactiveTimers;
        this.validateInvocationContext();
        LinkedList<jakarta.ejb.Timer> timers = new LinkedList<jakarta.ejb.Timer>();
        Set set = inactiveTimers = ManagedTimerService.getActiveTransaction() != null ? (Set)this.invoker.getComponent().getTransactionSynchronizationRegistry().getResource(this.manager) : null;
        if (inactiveTimers != null) {
            this.addTimers(timers, inactiveTimers);
        }
        try (Stream activeTimers = this.manager.getActiveTimers();){
            this.addTimers(timers, activeTimers::iterator);
        }
        return Collections.unmodifiableCollection(timers);
    }

    private void addTimers(Collection<jakarta.ejb.Timer> timers, Iterable<I> timerIds) {
        OOBTimer<I> currentTimer = Optional.ofNullable(CurrentInvocationContext.get()).map(InterceptorContext::getTimer).filter(ManagedTimer.class::isInstance).map(ManagedTimer.class::cast).orElse(null);
        for (I timerId : timerIds) {
            OOBTimer<I> timer = new OOBTimer<I>(this.manager, timerId, this.invoker, this.synchronizationFactory);
            timers.add(Objects.equals(timer, currentTimer) ? currentTimer : timer);
        }
    }

    public Collection<jakarta.ejb.Timer> getAllTimers() throws EJBException {
        this.validateInvocationContext();
        return this.registry.getAllTimers();
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.invoker.getTimedObjectId());
    }

    static class SimpleScheduleTimerConfiguration
    implements ScheduleTimerConfiguration {
        private final ImmutableScheduleExpression expression;

        SimpleScheduleTimerConfiguration(ScheduleExpression expression) {
            this.expression = new SimpleImmutableScheduleExpression(expression);
        }

        public ImmutableScheduleExpression getScheduleExpression() {
            return this.expression;
        }
    }

    static class ScheduleTimerFactory<I>
    implements BiFunction<TimerManager<I>, I, Timer<I>> {
        private final ScheduleTimerConfiguration configuration;
        private final Object info;

        ScheduleTimerFactory(ScheduleExpression expression, Object info) {
            this.configuration = new SimpleScheduleTimerConfiguration(expression);
            this.info = info;
        }

        @Override
        public Timer<I> apply(TimerManager<I> manager, I id) {
            return manager.createTimer(id, this.configuration, this.info);
        }
    }

    static class IntervalTimerFactory<I>
    implements BiFunction<TimerManager<I>, I, Timer<I>>,
    IntervalTimerConfiguration {
        private final Instant start;
        private final Duration interval;
        private final Object info;

        IntervalTimerFactory(Instant start, Duration interval, Object info) {
            this.start = start;
            this.interval = interval;
            this.info = info;
        }

        public Instant getStart() {
            return this.start;
        }

        public Duration getInterval() {
            return this.interval;
        }

        @Override
        public Timer<I> apply(TimerManager<I> manager, I id) {
            return manager.createTimer(id, (IntervalTimerConfiguration)this, this.info);
        }
    }
}

