/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteInputStream;

public class LimitedByteInput
extends ByteInputStream {
    private final long limit;
    private long count;

    public LimitedByteInput(ByteInput byteInput, long limit) {
        super(byteInput);
        this.limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        long count = this.count;
        if (count < this.limit) {
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.count = count + 1L;
            }
        }
        throw new IOException("Limit exceeded");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        long count = this.count;
        long limit = this.limit;
        if (count >= limit) {
            throw new IOException("Limit exceeded");
        }
        if (count + (long)len >= limit) {
            int rem = (int)(limit - count);
            ret = super.read(b, off, rem);
        } else {
            ret = super.read(b, off, len);
        }
        this.count = count + (long)ret;
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret;
        long count = this.count;
        long limit = this.limit;
        if (count >= limit) {
            throw new IOException("Limit exceeded");
        }
        if (count + n >= limit) {
            int rem = (int)(limit - count);
            ret = super.skip(rem);
        } else {
            ret = super.skip(n);
        }
        this.count = count + ret;
        return ret;
    }
}

