/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandler;
import org.jboss.as.controller.remote.ModelControllerClientOperationHandlerFactoryService;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.controller.remote.TransactionalProtocolOperationHandler;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.HostRegistrations;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.FetchMissingConfigurationHandler;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.DomainHostExcludeRegistry;
import org.jboss.as.host.controller.mgmt.HostControllerRegistrationHandler;
import org.jboss.as.host.controller.mgmt.MasterDomainControllerOperationHandlerImpl;
import org.jboss.as.host.controller.mgmt.SlaveChannelAttachments;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementPongRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.remoting3.Channel;

public class MasterDomainControllerOperationHandlerService
extends AbstractModelControllerOperationHandlerFactoryService {
    public static final ServiceName SERVICE_NAME = DomainController.SERVICE_NAME.append(ModelControllerClientOperationHandlerFactoryService.OPERATION_HANDLER_NAME_SUFFIX);
    private final DomainController domainController;
    private final HostControllerRegistrationHandler.OperationExecutor operationExecutor;
    private final TransactionalOperationExecutor txOperationExecutor;
    private final ManagementPongRequestHandler pongRequestHandler = new ManagementPongRequestHandler();
    private final File tempDir;
    private final HostRegistrations slaveHostRegistrations;
    private final DomainHostExcludeRegistry domainHostExcludeRegistry;

    public MasterDomainControllerOperationHandlerService(Consumer<AbstractModelControllerOperationHandlerFactoryService> serviceConsumer, Supplier<ModelController> modelControllerSupplier, Supplier<ExecutorService> executorSupplier, Supplier<ScheduledExecutorService> scheduledExecutorSupplier, DomainController domainController, HostControllerRegistrationHandler.OperationExecutor operationExecutor, TransactionalOperationExecutor txOperationExecutor, File tempDir, HostRegistrations slaveHostRegistrations, DomainHostExcludeRegistry domainHostExcludeRegistry) {
        super(serviceConsumer, modelControllerSupplier, executorSupplier, scheduledExecutorSupplier);
        this.domainController = domainController;
        this.operationExecutor = operationExecutor;
        this.txOperationExecutor = txOperationExecutor;
        this.tempDir = tempDir;
        this.slaveHostRegistrations = slaveHostRegistrations;
        this.domainHostExcludeRegistry = domainHostExcludeRegistry;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.pongRequestHandler.resetConnectionId();
        super.start(context);
    }

    public ManagementChannelHandler startReceiving(Channel channel) {
        DomainControllerLogger.ROOT_LOGGER.debugf("Starting receiving from a remote HostController on channel %s", channel);
        ManagementChannelHandler handler = new ManagementChannelHandler(ManagementClientChannelStrategy.create((Channel)channel), this.getExecutor());
        handler.getAttachments().attach(ManagementChannelHandler.TEMP_DIR, (Object)this.tempDir);
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new HostControllerRegistrationHandler(handler, this.domainController, this.operationExecutor, this.getExecutor(), this.slaveHostRegistrations, this.domainHostExcludeRegistry));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new ModelControllerClientOperationHandler(this.getController(), (ManagementChannelAssociation)handler, this.getResponseAttachmentSupport(), this.getClientRequestExecutor()));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new MasterDomainControllerOperationHandlerImpl(this.domainController, this.getExecutor()));
        handler.addHandlerFactory((ManagementRequestHandlerFactory)this.pongRequestHandler);
        handler.addHandlerFactory((ManagementRequestHandlerFactory)new DomainTransactionalProtocolOperationHandler(this.txOperationExecutor, (ManagementChannelAssociation)handler, this.getResponseAttachmentSupport()));
        channel.receiveMessage(handler.getReceiver());
        return handler;
    }

    public static interface TransactionalOperationExecutor {
        public OperationResponse executeAndAttemptLock(Operation var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationStepHandler var4);

        public ModelNode joinActiveOperation(ModelNode var1, OperationMessageHandler var2, ModelController.OperationTransactionControl var3, OperationStepHandler var4, int var5);
    }

    private class DomainTransactionalProtocolOperationHandler
    extends TransactionalProtocolOperationHandler {
        private final TransactionalOperationExecutor executor;
        private volatile SlaveRequest activeSlaveRequest;

        public DomainTransactionalProtocolOperationHandler(TransactionalOperationExecutor executor, ManagementChannelAssociation channelAssociation, ResponseAttachmentInputStreamSupport responseAttachmentSupport) {
            super(null, channelAssociation, responseAttachmentSupport);
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected OperationResponse internalExecute(Operation operation, ManagementRequestContext<?> context, OperationMessageHandler messageHandler, ModelController.OperationTransactionControl control) {
            Object object;
            DomainTransactionalProtocolOperationHandler domainTransactionalProtocolOperationHandler;
            FetchMissingConfigurationHandler handler;
            block22: {
                DomainTransactionalProtocolOperationHandler domainTransactionalProtocolOperationHandler2;
                ModelNode operationNode = operation.getOperation();
                String operationName = operation.getOperation().require("operation").asString();
                if (!operationName.equals(FetchMissingConfigurationHandler.OPERATION_NAME)) {
                    throw HostControllerLogger.ROOT_LOGGER.cannotExecuteTransactionalOperationFromSlave(operationName);
                }
                handler = new FetchMissingConfigurationHandler(SlaveChannelAttachments.getHostName(context.getChannel()), SlaveChannelAttachments.getDomainIgnoredExtensions(context.getChannel()), SlaveChannelAttachments.getTransformers(context.getChannel()), MasterDomainControllerOperationHandlerService.this.domainController.getExtensionRegistry());
                Integer domainControllerLockId = operationNode.get("operation-headers").hasDefined("domain-controller-lock-id") ? Integer.valueOf(operationNode.get(new String[]{"operation-headers", "domain-controller-lock-id"}).asInt()) : null;
                if (domainControllerLockId == null) {
                    domainTransactionalProtocolOperationHandler = this;
                    synchronized (domainTransactionalProtocolOperationHandler) {
                        SlaveRequest slaveRequest = this.activeSlaveRequest;
                        if (slaveRequest != null) {
                            domainControllerLockId = slaveRequest.domainId;
                            slaveRequest.refCount.incrementAndGet();
                        }
                    }
                }
                try {
                    if (domainControllerLockId == null) break block22;
                    assert (operation.getInputStreams().isEmpty());
                    ModelNode responseNode = this.executor.joinActiveOperation(operation.getOperation(), messageHandler, control, handler, domainControllerLockId);
                    object = OperationResponse.Factory.createSimple((ModelNode)responseNode);
                    domainTransactionalProtocolOperationHandler2 = this;
                }
                catch (Throwable throwable) {
                    DomainTransactionalProtocolOperationHandler domainTransactionalProtocolOperationHandler3 = this;
                    synchronized (domainTransactionalProtocolOperationHandler3) {
                        int refcount;
                        SlaveRequest slaveRequest = this.activeSlaveRequest;
                        if (slaveRequest != null && (refcount = slaveRequest.refCount.decrementAndGet()) == 0) {
                            this.activeSlaveRequest = null;
                        }
                    }
                    throw throwable;
                }
                synchronized (domainTransactionalProtocolOperationHandler2) {
                    int refcount;
                    SlaveRequest slaveRequest = this.activeSlaveRequest;
                    if (slaveRequest != null && (refcount = slaveRequest.refCount.decrementAndGet()) == 0) {
                        this.activeSlaveRequest = null;
                    }
                }
                return object;
            }
            domainTransactionalProtocolOperationHandler = this.executor.executeAndAttemptLock(operation, messageHandler, control, new OperationStepHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    Integer domainControllerLockId = CurrentOperationIdHolder.getCurrentOperationID();
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        DomainTransactionalProtocolOperationHandler.this.activeSlaveRequest = new SlaveRequest(domainControllerLockId);
                    }
                    context.addStep(operation, handler, OperationContext.Stage.MODEL);
                }
            });
            object = this;
            synchronized (object) {
                int refcount;
                SlaveRequest slaveRequest = this.activeSlaveRequest;
                if (slaveRequest != null && (refcount = slaveRequest.refCount.decrementAndGet()) == 0) {
                    this.activeSlaveRequest = null;
                }
            }
            return domainTransactionalProtocolOperationHandler;
        }
    }

    private final class SlaveRequest {
        private final int domainId;
        private final AtomicInteger refCount = new AtomicInteger(1);

        SlaveRequest(int domainId) {
            this.domainId = domainId;
        }
    }
}

