/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.util;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.objectfilter.impl.util.Interval;

public final class IntervalTree<K extends Comparable<K>, V> {
    private final Node<K, V> sentinel = new Node();
    private final Node<K, V> root;

    public IntervalTree() {
        this.sentinel.left = this.sentinel;
        this.sentinel.right = this.sentinel;
        this.sentinel.parent = this.sentinel;
        this.root = this.sentinel;
    }

    private int compare(K k1, K k2) {
        if (k1 == Interval.getMinusInf() || k2 == Interval.getPlusInf()) {
            return -1;
        }
        if (k1 == Interval.getPlusInf() || k2 == Interval.getMinusInf()) {
            return 1;
        }
        return k1.compareTo(k2);
    }

    private K max(K k1, K k2) {
        return this.compare(k1, k2) >= 0 ? k1 : k2;
    }

    private boolean compareLowerBound(Interval<K> i1, Interval<K> i2) {
        int res = this.compare(i1.low, i2.low);
        return res < 0 || res == 0 && (i1.includeLower || !i2.includeUpper);
    }

    private int compareIntervals(Interval<K> i1, Interval<K> i2) {
        int res1 = this.compare(i1.up, i2.low);
        if (res1 < 0 || res1 <= 0 && (!i1.includeUpper || !i2.includeLower)) {
            return -1;
        }
        int res2 = this.compare(i2.up, i1.low);
        if (res2 < 0 || res2 <= 0 && (!i2.includeUpper || !i1.includeLower)) {
            return 1;
        }
        return 0;
    }

    private void checkValidInterval(Interval<K> interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Interval cannot be null");
        }
        if (this.compare(interval.low, interval.up) > 0) {
            throw new IllegalArgumentException("Interval lower bound cannot be higher than the upper bound");
        }
    }

    public Node<K, V> add(Interval<K> i) {
        this.checkValidInterval(i);
        return this.add(new Node(i));
    }

    private Node<K, V> add(Node<K, V> n) {
        Node x;
        n.right = this.sentinel;
        n.left = n.right;
        Node<K, V> y = this.root;
        Node node = x = this.root != null ? this.root.left : null;
        while (x != this.sentinel) {
            y = x;
            if (n.interval.equals(x.interval)) {
                return x;
            }
            x = this.compareLowerBound(n.interval, y.interval) ? x.left : x.right;
            y.max = this.max(n.max, y.max);
            if (y.parent != this.root) continue;
            this.root.max = y.max;
        }
        n.parent = y;
        if (this.root != null && y == this.root) {
            this.root.max = n.max;
        }
        if (y != null) {
            if (y == this.root || this.compareLowerBound(n.interval, y.interval)) {
                y.left = n;
            } else {
                y.right = n;
            }
        }
        this.rebalanceAfterAdd(n);
        return n;
    }

    private void rebalanceAfterAdd(Node<K, V> z) {
        z.isRed = true;
        while (z.parent.isRed) {
            Node y;
            if (z.parent == z.parent.parent.left) {
                y = z.parent.parent.right;
                if (y.isRed) {
                    z.parent.isRed = false;
                    y.isRed = false;
                    z.parent.parent.isRed = true;
                    z = z.parent.parent;
                    continue;
                }
                if (z == z.parent.right) {
                    z = z.parent;
                    this.rotateLeft(z);
                }
                z.parent.isRed = false;
                z.parent.parent.isRed = true;
                this.rotateRight(z.parent.parent);
                continue;
            }
            y = z.parent.parent.left;
            if (y.isRed) {
                z.parent.isRed = false;
                y.isRed = false;
                z.parent.parent.isRed = true;
                z = z.parent.parent;
                continue;
            }
            if (z == z.parent.left) {
                z = z.parent;
                this.rotateRight(z);
            }
            z.parent.isRed = false;
            z.parent.parent.isRed = true;
            this.rotateLeft(z.parent.parent);
        }
        this.root.left.isRed = false;
    }

    private void rotateLeft(Node<K, V> x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != this.sentinel) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
        if (y.parent == this.root) {
            this.root.max = x.max;
        }
        y.max = x.max;
        x.max = this.max(x.interval.up, this.max(x.left.max, x.right.max));
    }

    private void rotateRight(Node<K, V> x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right != this.sentinel) {
            y.right.parent = x;
        }
        y.parent = x.parent;
        if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.right = x;
        x.parent = y;
        if (y.parent == this.root) {
            this.root.max = x.max;
        }
        y.max = x.max;
        x.max = this.max(x.interval.up, this.max(x.left.max, x.right.max));
    }

    public boolean remove(Interval<K> i) {
        this.checkValidInterval(i);
        return this.remove(this.root.left, i);
    }

    private boolean remove(Node<K, V> n, Interval<K> i) {
        if (n == this.sentinel || this.compare(i.low, n.max) > 0) {
            return false;
        }
        if (n.interval.equals(i)) {
            this.remove(n);
            return true;
        }
        if (n.left != this.sentinel && this.remove(n.left, i)) {
            return true;
        }
        if (this.compareIntervals(i, n.interval) < 0) {
            return false;
        }
        return n.right != this.sentinel && this.remove(n.right, i);
    }

    public void remove(Node<K, V> n) {
        n.max = Interval.getMinusInf();
        Node i = n.parent;
        while (i != this.root) {
            i.max = this.max(i.left.max, i.right.max);
            if (i.parent == this.root) {
                this.root.max = i.max;
            }
            i = i.parent;
        }
        Node<K, V> y = n.left == this.sentinel || n.right == this.sentinel ? n : this.findSuccessor(n);
        Node x = y.left == this.sentinel ? y.right : y.left;
        x.parent = y.parent;
        if (this.root == x.parent) {
            this.root.left = x;
        } else if (y == y.parent.left) {
            y.parent.left = x;
        } else {
            y.parent.right = x;
        }
        if (y != n) {
            if (!y.isRed) {
                this.rebalanceAfterRemove(x);
            }
            y.left = n.left;
            y.right = n.right;
            y.parent = n.parent;
            y.isRed = n.isRed;
            n.left.parent = n.right.parent = y;
            if (n == n.parent.left) {
                n.parent.left = y;
            } else {
                n.parent.right = y;
            }
        } else if (!y.isRed) {
            this.rebalanceAfterRemove(x);
        }
    }

    private Node<K, V> findSuccessor(Node<K, V> x) {
        Node successor = x.right;
        if (successor != this.sentinel) {
            while (successor.left != this.sentinel) {
                successor = successor.left;
            }
            return successor;
        }
        successor = x.parent;
        while (x == successor.right) {
            x = successor;
            successor = successor.parent;
        }
        if (successor == this.root) {
            return this.sentinel;
        }
        return successor;
    }

    private void rebalanceAfterRemove(Node<K, V> x) {
        while (x != this.root.left && !x.isRed) {
            Node w;
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w.isRed) {
                    w.isRed = false;
                    x.parent.isRed = true;
                    this.rotateLeft(x.parent);
                    w = x.parent.right;
                }
                if (!w.left.isRed && !w.right.isRed) {
                    w.isRed = true;
                    x = x.parent;
                    continue;
                }
                if (!w.right.isRed) {
                    w.left.isRed = false;
                    w.isRed = true;
                    this.rotateRight(w);
                    w = x.parent.right;
                }
                w.isRed = x.parent.isRed;
                x.parent.isRed = false;
                w.right.isRed = false;
                this.rotateLeft(x.parent);
                x = this.root.left;
                continue;
            }
            w = x.parent.left;
            if (w.isRed) {
                w.isRed = false;
                x.parent.isRed = true;
                this.rotateRight(x.parent);
                w = x.parent.left;
            }
            if (!w.right.isRed && !w.left.isRed) {
                w.isRed = true;
                x = x.parent;
                continue;
            }
            if (!w.left.isRed) {
                w.right.isRed = false;
                w.isRed = true;
                this.rotateLeft(w);
                w = x.parent.left;
            }
            w.isRed = x.parent.isRed;
            x.parent.isRed = false;
            w.left.isRed = false;
            this.rotateRight(x.parent);
            x = this.root.left;
        }
        x.isRed = false;
    }

    public boolean isEmpty() {
        return this.root.left == this.sentinel;
    }

    public List<Node<K, V>> stab(K k) {
        Interval<K> i = new Interval<K>(k, true, k, true);
        ArrayList nodes = new ArrayList();
        this.findOverlap(this.root.left, i, node -> nodes.add(node));
        return nodes;
    }

    public void stab(K k, NodeCallback<K, V> nodeCallback) {
        Interval<K> i = new Interval<K>(k, true, k, true);
        this.findOverlap(this.root.left, i, nodeCallback);
    }

    private void findOverlap(Node<K, V> n, Interval<K> i, NodeCallback<K, V> nodeCallback) {
        if (n == this.sentinel || this.compare(i.low, n.max) > 0) {
            return;
        }
        if (n.left != this.sentinel) {
            this.findOverlap(n.left, i, nodeCallback);
        }
        if (this.compareIntervals(n.interval, i) == 0) {
            nodeCallback.handle(n);
        }
        if (this.compareIntervals(i, n.interval) < 0) {
            return;
        }
        if (n.right != this.sentinel) {
            this.findOverlap(n.right, i, nodeCallback);
        }
    }

    public Node<K, V> findNode(Interval<K> i) {
        this.checkValidInterval(i);
        return this.findNode(this.root.left, i);
    }

    private Node<K, V> findNode(Node<K, V> n, Interval<K> i) {
        Node w;
        if (n == this.sentinel || this.compare(i.low, n.max) > 0) {
            return null;
        }
        if (n.interval.equals(i)) {
            return n;
        }
        if (n.left != this.sentinel && (w = this.findNode(n.left, i)) != null) {
            return w;
        }
        if (this.compareIntervals(i, n.interval) < 0) {
            return null;
        }
        if (n.right != this.sentinel) {
            return this.findNode(n.right, i);
        }
        return null;
    }

    public void inorderTraversal(NodeCallback<K, V> nodeCallback) {
        this.inorderTraversal(this.root.left, nodeCallback);
    }

    private void inorderTraversal(Node<K, V> n, NodeCallback<K, V> nodeCallback) {
        if (n != this.sentinel) {
            this.inorderTraversal(n.left, nodeCallback);
            nodeCallback.handle(n);
            this.inorderTraversal(n.right, nodeCallback);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.inorderTraversal(n -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(n.interval).append("->{").append(n.value).append('}');
        });
        return sb.toString();
    }

    public static final class Node<K extends Comparable<K>, V> {
        public final Interval<K> interval;
        public V value;
        private K max;
        private Node<K, V> parent;
        private Node<K, V> left;
        private Node<K, V> right;
        private boolean isRed = false;

        private Node(Interval<K> interval) {
            this.interval = interval;
            this.max = interval.up;
        }

        private Node() {
            this.interval = null;
        }
    }

    @FunctionalInterface
    public static interface NodeCallback<K extends Comparable<K>, V> {
        public void handle(Node<K, V> var1);
    }
}

