/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.cache.CacheConfiguration;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.expiration.Expiration;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionStatistics;
import org.wildfly.clustering.session.cache.AttachedSession;
import org.wildfly.clustering.session.cache.ManagedSession;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.SimpleImmutableSession;

public abstract class AbstractSessionManager<DC, MV, AV, SC>
implements SessionManager<SC>,
SessionStatistics {
    protected final System.Logger logger = System.getLogger(this.getClass().getName());
    private final SessionFactory<DC, MV, AV, SC> sessionFactory;
    private final BiFunction<String, SC, Session<SC>> detachedSessionFactory;
    private final Consumer<ImmutableSession> expirationListener;
    private final Expiration expiration;
    private final IdentifierFactoryService<String> identifierFactory;
    private final DC context;
    private final Supplier<Batch> batchFactory;
    private final UnaryOperator<Session<SC>> wrapper;

    protected AbstractSessionManager(final Configuration<DC, MV, AV, SC> configuration) {
        this.identifierFactory = configuration.getIdentifierFactory();
        this.context = configuration.getContext();
        this.batchFactory = configuration.getCacheConfiguration().getBatchFactory();
        this.expiration = configuration;
        this.expirationListener = configuration.getExpirationListener();
        this.sessionFactory = configuration.getSessionFactory();
        this.detachedSessionFactory = configuration.getDetachedSessionFactory();
        this.wrapper = new UnaryOperator<Session<SC>>(this){
            final /* synthetic */ AbstractSessionManager this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Session<SC> apply(Session<SC> session) {
                return new ManagedSession(new AttachedSession(session, configuration.getSessionCloseTask()), configuration.getDetachedSessionFactory().apply(session.getId(), session.getContext()));
            }
        };
    }

    public boolean isStarted() {
        return this.identifierFactory.isStarted();
    }

    public void start() {
        this.identifierFactory.start();
    }

    public void stop() {
        this.identifierFactory.stop();
    }

    public Supplier<String> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public CompletionStage<Session<SC>> createSessionAsync(String id) {
        this.logger.log(System.Logger.Level.TRACE, "Creating session {0}", id);
        return this.sessionFactory.createValueAsync(id, this.expiration.getTimeout()).thenApply(entry -> (Session)this.wrapper.apply(this.sessionFactory.createSession(id, (Map.Entry<MV, AV>)entry, this.context)));
    }

    public CompletionStage<Session<SC>> findSessionAsync(String id) {
        this.logger.log(System.Logger.Level.TRACE, "Locating session {0}", id);
        return this.sessionFactory.findValueAsync(id).thenApply(entry -> {
            if (entry == null) {
                this.logger.log(System.Logger.Level.TRACE, "Session {0} not found", id);
                return null;
            }
            ImmutableSession session = this.sessionFactory.createImmutableSession(id, (Map.Entry<MV, AV>)entry);
            if (session.getMetaData().isExpired()) {
                this.logger.log(System.Logger.Level.TRACE, "Session {0} was found, but has expired: {1}", id, session.getMetaData());
                this.expirationListener.accept(session);
                this.sessionFactory.removeAsync(id);
                return null;
            }
            return (Session)this.wrapper.apply(this.sessionFactory.createSession(id, (Map.Entry<MV, AV>)entry, this.context));
        });
    }

    public CompletionStage<ImmutableSession> findImmutableSessionAsync(String id) {
        return this.sessionFactory.findValueAsync(id).thenApply(entry -> entry != null ? new SimpleImmutableSession(this.sessionFactory.createImmutableSession(id, (Map.Entry<MV, AV>)entry)) : null);
    }

    public Session<SC> getDetachedSession(String id) {
        return this.detachedSessionFactory.apply(id, this.sessionFactory.getSessionContextFactory().get());
    }

    public SessionStatistics getStatistics() {
        return this;
    }

    protected static interface Configuration<DC, MV, AV, SC>
    extends SessionManagerConfiguration<DC> {
        public IdentifierFactoryService<String> getIdentifierFactory();

        public CacheConfiguration getCacheConfiguration();

        public SessionFactory<DC, MV, AV, SC> getSessionFactory();

        public BiFunction<String, SC, Session<SC>> getDetachedSessionFactory();

        public Consumer<ImmutableSession> getSessionCloseTask();
    }
}

