/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache;

import java.util.Map;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeImmutableSession;
import org.wildfly.clustering.session.cache.ImmutableSessionFactory;
import org.wildfly.clustering.session.cache.ImmutableSessionFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.ImmutableSessionAttributesFactory;
import org.wildfly.clustering.session.cache.metadata.ImmutableSessionMetaDataFactory;

public class CompositeImmutableSessionFactory<MV, AV>
implements ImmutableSessionFactory<MV, AV> {
    private final ImmutableSessionMetaDataFactory<MV> metaDataFactory;
    private final ImmutableSessionAttributesFactory<AV> attributesFactory;
    private final CacheProperties properties;

    public CompositeImmutableSessionFactory(ImmutableSessionFactoryConfiguration<MV, AV> configuration) {
        this.metaDataFactory = configuration.getSessionMetaDataFactory();
        this.attributesFactory = configuration.getSessionAttributesFactory();
        this.properties = configuration.getCacheProperties();
    }

    @Override
    public ImmutableSessionMetaDataFactory<MV> getSessionMetaDataFactory() {
        return this.metaDataFactory;
    }

    @Override
    public ImmutableSessionAttributesFactory<AV> getSessionAttributesFactory() {
        return this.attributesFactory;
    }

    @Override
    public ImmutableSession createImmutableSession(String id, ImmutableSessionMetaData metaData, Map<String, Object> attributes) {
        return new CompositeImmutableSession(id, metaData, attributes);
    }

    @Override
    public CacheProperties getCacheProperties() {
        return this.properties;
    }
}

