/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.AbstractProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.FieldReadable;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.OffsetProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.Reference;

public class DefaultProtoStreamReader
extends AbstractProtoStreamOperation
implements ProtoStreamReader,
ProtobufTagMarshaller.ReadContext {
    private final TagReader reader;
    private final ProtoStreamReaderContext context;
    private int currentTag = 0;

    DefaultProtoStreamReader(ProtobufTagMarshaller.ReadContext context) {
        this(context, new DefaultProtoStreamReaderContext());
    }

    DefaultProtoStreamReader(ProtobufTagMarshaller.ReadContext context, ProtoStreamReaderContext readerContext) {
        super((ProtobufTagMarshaller.OperationContext)context);
        this.reader = context.getReader();
        this.context = readerContext;
    }

    @Override
    public ProtoStreamOperation.Context getContext() {
        return this.context;
    }

    public TagReader getReader() {
        return this.reader;
    }

    @Override
    public <T> FieldSetReader<T> createFieldSetReader(final FieldReadable<T> reader, final int startIndex) {
        final int endIndex = reader.nextIndex(startIndex);
        final OffsetProtoStreamReader offsetReader = new OffsetProtoStreamReader(this, startIndex);
        return new FieldSetReader<T>(this){
            final /* synthetic */ DefaultProtoStreamReader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T readField(T current) throws IOException {
                int tag = offsetReader.getCurrentTag();
                int relativeIndex = WireType.getTagFieldNumber((int)tag) - startIndex;
                return reader.readFrom(offsetReader, relativeIndex, WireType.fromTag((int)tag), current);
            }

            @Override
            public boolean contains(int index) {
                return index >= startIndex && index < endIndex;
            }
        };
    }

    public int pushLimit(int limit) throws IOException {
        return this.reader.pushLimit(limit);
    }

    public void popLimit(int oldLimit) {
        this.reader.popLimit(oldLimit);
    }

    public int readTag() throws IOException {
        this.currentTag = this.reader.readTag();
        return this.currentTag;
    }

    @Override
    public int getCurrentTag() {
        return this.currentTag;
    }

    public void checkLastTagWas(int tag) throws IOException {
        this.reader.checkLastTagWas(tag);
    }

    public boolean skipField(int tag) throws IOException {
        this.currentTag = 0;
        return this.reader.skipField(tag);
    }

    public boolean isAtEnd() throws IOException {
        return this.reader.isAtEnd();
    }

    @Override
    public Object readAny() throws IOException {
        Object result = this.readObject(Any.class).get();
        if (result instanceof Reference) {
            Reference reference = (Reference)result;
            result = this.context.resolve(reference);
        } else {
            this.context.record(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readObject(Class<T> targetClass) throws IOException {
        this.verifyWireType(WireType.LENGTH_DELIMITED);
        int limit = this.reader.readUInt32();
        int oldLimit = this.reader.pushLimit(limit);
        try {
            ProtoStreamMarshaller marshaller = this.findMarshaller(targetClass);
            Object result = marshaller.readFrom(this);
            this.reader.checkLastTagWas(0);
            Object object = result;
            return (T)object;
        }
        finally {
            this.reader.popLimit(oldLimit);
        }
    }

    public boolean readBool() throws IOException {
        this.verifyWireType(WireType.VARINT);
        this.currentTag = 0;
        return this.reader.readBool();
    }

    public int readEnum() throws IOException {
        this.verifyWireType(WireType.VARINT);
        this.currentTag = 0;
        return this.reader.readEnum();
    }

    @Override
    @Deprecated
    public int readInt32() throws IOException {
        this.verifyWireType(WireType.VARINT);
        this.currentTag = 0;
        return this.reader.readInt32();
    }

    @Override
    @Deprecated
    public int readFixed32() throws IOException {
        this.verifyWireType(WireType.FIXED32);
        this.currentTag = 0;
        return this.reader.readFixed32();
    }

    public int readUInt32() throws IOException {
        this.verifyWireType(EnumSet.of(WireType.VARINT, WireType.LENGTH_DELIMITED));
        this.currentTag = 0;
        return this.reader.readUInt32();
    }

    public int readSInt32() throws IOException {
        this.verifyWireType(WireType.VARINT);
        this.currentTag = 0;
        return this.reader.readSInt32();
    }

    public int readSFixed32() throws IOException {
        this.verifyWireType(WireType.FIXED32);
        this.currentTag = 0;
        return this.reader.readSFixed32();
    }

    @Override
    @Deprecated
    public long readInt64() throws IOException {
        this.verifyWireType(WireType.VARINT);
        this.currentTag = 0;
        return this.reader.readInt64();
    }

    @Override
    @Deprecated
    public long readFixed64() throws IOException {
        this.verifyWireType(WireType.FIXED64);
        this.currentTag = 0;
        return this.reader.readFixed64();
    }

    public long readUInt64() throws IOException {
        this.verifyWireType(WireType.VARINT);
        this.currentTag = 0;
        return this.reader.readUInt64();
    }

    public long readSInt64() throws IOException {
        this.verifyWireType(WireType.VARINT);
        this.currentTag = 0;
        return this.reader.readSInt64();
    }

    public long readSFixed64() throws IOException {
        this.verifyWireType(WireType.FIXED64);
        this.currentTag = 0;
        return this.reader.readSFixed64();
    }

    public float readFloat() throws IOException {
        this.verifyWireType(EnumSet.of(WireType.FIXED32, WireType.VARINT));
        this.currentTag = 0;
        return this.reader.readFloat();
    }

    public double readDouble() throws IOException {
        this.verifyWireType(EnumSet.of(WireType.FIXED64, WireType.VARINT));
        this.currentTag = 0;
        return this.reader.readDouble();
    }

    public byte[] readByteArray() throws IOException {
        this.verifyWireType(WireType.LENGTH_DELIMITED);
        this.currentTag = 0;
        return this.reader.readByteArray();
    }

    public ByteBuffer readByteBuffer() throws IOException {
        this.verifyWireType(WireType.LENGTH_DELIMITED);
        this.currentTag = 0;
        return this.reader.readByteBuffer();
    }

    public String readString() throws IOException {
        this.verifyWireType(WireType.LENGTH_DELIMITED);
        this.currentTag = 0;
        return this.reader.readString();
    }

    public byte[] fullBufferArray() throws IOException {
        this.verifyWireType(WireType.LENGTH_DELIMITED);
        return this.reader.fullBufferArray();
    }

    public InputStream fullBufferInputStream() throws IOException {
        this.verifyWireType(WireType.LENGTH_DELIMITED);
        return this.reader.fullBufferInputStream();
    }

    public boolean isInputStream() {
        return this.reader.isInputStream();
    }

    private void verifyWireType(WireType type) throws IOException {
        this.verifyWireType(EnumSet.of(type));
    }

    private void verifyWireType(Set<WireType> types) throws IOException {
        WireType currentType = WireType.fromTag((int)this.currentTag);
        if (!types.contains(currentType)) {
            throw new IllegalStateException(currentType.name());
        }
    }

    private static class DefaultProtoStreamReaderContext
    implements ProtoStreamReaderContext {
        private final Map<Object, Boolean> objects = new IdentityHashMap<Object, Boolean>(128);
        private final List<Object> references = new ArrayList<Object>(128);

        private DefaultProtoStreamReaderContext() {
        }

        @Override
        public void record(Object object) {
            if (object != null && this.objects.putIfAbsent(object, Boolean.TRUE) == null) {
                this.references.add(object);
            }
        }

        @Override
        public Object resolve(Reference reference) {
            return this.references.get(reference.getAsInt());
        }
    }

    static interface ProtoStreamReaderContext
    extends ProtoStreamOperation.Context {
        public Object resolve(Reference var1);
    }
}

