/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.math;

import java.io.IOException;
import java.math.MathContext;
import java.math.RoundingMode;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum MathContextMarshaller implements ProtoStreamMarshaller<MathContext>
{
    INSTANCE;

    private static final int PRECISION_INDEX = 1;
    private static final int ROUNDING_MODE_INDEX = 2;
    private static final int DEFAULT_PRECISION = 0;
    private static final RoundingMode DEFAULT_ROUNDING_MODE;

    @Override
    public MathContext readFrom(ProtoStreamReader reader) throws IOException {
        int precision = 0;
        RoundingMode mode = DEFAULT_ROUNDING_MODE;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    precision = reader.readUInt32();
                    continue block4;
                }
                case 2: {
                    mode = reader.readEnum(RoundingMode.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new MathContext(precision, mode);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, MathContext context) throws IOException {
        RoundingMode mode;
        int precision = context.getPrecision();
        if (precision != 0) {
            writer.writeUInt32(1, precision);
        }
        if ((mode = context.getRoundingMode()) != DEFAULT_ROUNDING_MODE) {
            writer.writeEnum(2, mode);
        }
    }

    @Override
    public Class<? extends MathContext> getJavaClass() {
        return MathContext.class;
    }

    static {
        DEFAULT_ROUNDING_MODE = RoundingMode.HALF_UP;
    }
}

