/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;

public class LinkedHashMapMarshaller<K, V>
extends AbstractMapMarshaller<K, V, LinkedHashMap<K, V>> {
    static final ProtoStreamMarshaller<?> INSTANCE = new LinkedHashMapMarshaller();
    private static final int ACCESS_ORDER_INDEX = 2;
    private static final Function<LinkedHashMap<Object, Object>, Boolean> ACCESS_ORDER = new Function<LinkedHashMap<Object, Object>, Boolean>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean apply(LinkedHashMap<Object, Object> map) {
            Object insertOrder = new Object();
            map.put(insertOrder, null);
            try {
                Boolean bl;
                Object accessOrder = new Object();
                map.put(accessOrder, null);
                try {
                    map.get(insertOrder);
                    Iterator<Object> keys = map.keySet().iterator();
                    Object element = keys.next();
                    while (element != insertOrder && element != accessOrder) {
                        element = keys.next();
                    }
                    bl = element == accessOrder;
                }
                catch (Throwable throwable) {
                    map.remove(accessOrder);
                    throw throwable;
                }
                map.remove(accessOrder);
                return bl;
            }
            finally {
                map.remove(insertOrder);
            }
        }
    };

    private LinkedHashMapMarshaller() {
        super(LinkedHashMap.class);
    }

    @Override
    public LinkedHashMap<K, V> readFrom(ProtoStreamReader reader) throws IOException {
        boolean accessOrder = false;
        LinkedList<Map.Entry> entries = new LinkedList<Map.Entry>();
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    entries.add(reader.readObject(AbstractMap.SimpleEntry.class));
                    continue block4;
                }
                case 2: {
                    accessOrder = reader.readBool();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        LinkedHashMap map = new LinkedHashMap(16, 0.75f, accessOrder);
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ProtoStreamWriter writer, LinkedHashMap<K, V> map) throws IOException {
        LinkedHashMap<K, V> linkedHashMap = map;
        synchronized (linkedHashMap) {
            super.writeTo(writer, map);
            boolean accessOrder = ACCESS_ORDER.apply(map);
            if (accessOrder) {
                writer.writeBool(2, accessOrder);
            }
        }
    }
}

