/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneLeafSingleFieldPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;

public class LuceneTextRangePredicate
extends AbstractLuceneLeafSingleFieldPredicate {
    private LuceneTextRangePredicate(Builder<?> builder) {
        super(builder);
    }

    private static class Builder<F>
    extends AbstractLuceneLeafSingleFieldPredicate.AbstractBuilder<F>
    implements RangePredicateBuilder {
        private final LuceneFieldCodec<F, String> codec;
        private Range<String> range;

        private Builder(LuceneFieldCodec<F, String> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            super(scope, field);
            this.codec = codec;
        }

        public void within(Range<?> range, ValueModel lowerBoundModel, ValueModel upperBoundModel) {
            this.range = this.convertAndEncode(this.codec, range, lowerBoundModel, upperBoundModel);
        }

        public SearchPredicate build() {
            return new LuceneTextRangePredicate(this);
        }

        @Override
        protected Query buildQuery(PredicateRequestContext context) {
            return new TermRangeQuery(this.absoluteFieldPath, this.normalize(this.range.lowerBoundValue().orElse(null)), this.normalize(this.range.upperBoundValue().orElse(null)), RangeBoundInclusion.INCLUDED.equals((Object)this.range.lowerBoundInclusion()) || !this.range.lowerBoundValue().isPresent(), RangeBoundInclusion.INCLUDED.equals((Object)this.range.upperBoundInclusion()) || !this.range.upperBoundValue().isPresent());
        }

        private BytesRef normalize(String value) {
            if (value == null) {
                return null;
            }
            Analyzer searchAnalyzerOrNormalizer = this.field.type().searchAnalyzerOrNormalizer();
            return searchAnalyzerOrNormalizer.normalize(this.absoluteFieldPath, value);
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<RangePredicateBuilder, F, LuceneFieldCodec<F, String>> {
        public Factory(LuceneFieldCodec<F, String> codec) {
            super(codec);
        }

        @Override
        public Builder<F> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            return new Builder<F>(this.codec, scope, field);
        }
    }
}

