/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.wildfly.clustering.cache.infinispan.remote.AbstractRemoteCache;
import org.wildfly.clustering.function.BooleanSupplier;

public class ReadForUpdateRemoteCache<K, V>
extends AbstractRemoteCache<K, V> {
    private final org.wildfly.clustering.function.Function<MetadataValue<V>, V> value;
    private final RemoteCache<K, V> forceReturnCache;
    private final BooleanSupplier currentTransation;

    public ReadForUpdateRemoteCache(RemoteCache<K, V> cache) {
        super(cache);
        org.wildfly.clustering.function.Function value = VersionedValue::getValue;
        this.value = value.orDefault(Objects::nonNull, (Supplier)org.wildfly.clustering.function.Supplier.empty());
        this.forceReturnCache = cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE});
        final TransactionManager tm = cache.getTransactionManager();
        this.currentTransation = tm != null ? new BooleanSupplier(){
            final /* synthetic */ ReadForUpdateRemoteCache this$0;
            {
                this.this$0 = this$0;
            }

            public boolean getAsBoolean() {
                try {
                    return tm.getStatus() != 6;
                }
                catch (SystemException e) {
                    return false;
                }
            }
        } : BooleanSupplier.FALSE;
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return this.currentTransation.getAsBoolean() ? this.getWithMetadataAsync(key).thenApply((Function)this.value) : super.getAsync(key);
    }

    @Override
    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        CompletableFuture result = super.getWithMetadataAsync(key);
        return this.currentTransation.getAsBoolean() ? result.thenCompose(metadataValue -> {
            CompletableFuture<MetadataValue> completed = CompletableFuture.completedFuture(metadataValue);
            if (metadataValue == null) {
                return completed;
            }
            Object value = metadataValue.getValue();
            long version = metadataValue.getVersion();
            return this.forceReturnCache.replaceWithVersionAsync(key, value, version).thenCompose(replaced -> replaced != false ? completed : this.getWithMetadataAsync(key));
        }) : result;
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        if (!this.currentTransation.getAsBoolean()) {
            return super.getAllAsync(keys);
        }
        AtomicInteger remaining = new AtomicInteger(keys.size());
        ConcurrentHashMap entries = new ConcurrentHashMap();
        CompletableFuture result = new CompletableFuture();
        Iterator<?> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key;
            Object typedKey = key = iterator.next();
            this.getAsync(typedKey).whenComplete((value, exception) -> {
                if (exception != null) {
                    result.completeExceptionally((Throwable)exception);
                } else {
                    if (value != null) {
                        entries.put(typedKey, value);
                    }
                    if (remaining.decrementAndGet() == 0) {
                        result.complete(entries);
                    }
                }
            });
        }
        return result;
    }

    @Override
    public RemoteCache<K, V> apply(RemoteCache<K, V> cache) {
        return new ReadForUpdateRemoteCache<K, V>(cache);
    }
}

