/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.aesh.readline.terminal.formatting.Color;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.ColorConfig;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.SSLConfig;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.jboss.as.cli.impl.Namespace;
import org.jboss.as.cli.util.CLIExpressionResolver;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.common.xml.XMLInputFactoryUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

class CliConfigImpl
implements CliConfig {
    private static final Pattern VAULT_PATTERN = Pattern.compile("VAULT::.*::.*::.*");
    private static final String JBOSS_XML_CONFIG = "jboss.cli.config";
    private static final String CURRENT_WORKING_DIRECTORY = "user.dir";
    private static final String JBOSS_CLI_FILE = "jboss-cli.xml";
    private static final String ACCESS_CONTROL = "access-control";
    private static final String CONTROLLER = "controller";
    private static final String CONTROLLERS = "controllers";
    private static final String DEFAULT_CONTROLLER = "default-controller";
    private static final String DEFAULT_PROTOCOL = "default-protocol";
    private static final String ENABLED = "enabled";
    private static final String FILE_DIR = "file-dir";
    private static final String FILE_NAME = "file-name";
    private static final String JBOSS_CLI = "jboss-cli";
    private static final String HISTORY = "history";
    private static final String HOST = "host";
    private static final String MAX_SIZE = "max-size";
    private static final String NAME = "name";
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";
    private static final String CONNECTION_TIMEOUT = "connection-timeout";
    private static final String RESOLVE_PARAMETER_VALUES = "resolve-parameter-values";
    private static final String SILENT = "silent";
    private static final String USE_LEGACY_OVERRIDE = "use-legacy-override";
    private static final String VALIDATE_OPERATION_REQUESTS = "validate-operation-requests";
    private static final String ECHO_COMMAND = "echo-command";
    private static final String COMMAND_TIMEOUT = "command-timeout";
    private static final String OUTPUT_JSON = "output-json";
    private static final String COLOR_OUTPUT = "color-output";
    private static final String OUTPUT_PAGING = "output-paging";
    private static final Logger log = Logger.getLogger(CliConfig.class);
    private String defaultControllerProtocol = "remote+http";
    private boolean useLegacyOverride = true;
    private ControllerAddress defaultController = new ControllerAddress(null, "localhost", -1);
    private Map<String, ControllerAddress> controllerAliases = Collections.emptyMap();
    private boolean historyEnabled = true;
    private String historyFileName = ".jboss-cli-history";
    private String historyFileDir = WildFlySecurityManager.getPropertyPrivileged("user.home", null);
    private int historyMaxSize = 500;
    private int connectionTimeout = 5000;
    private boolean validateOperationRequests = true;
    private boolean resolveParameterValues = false;
    private SSLConfig sslConfig;
    private boolean silent;
    private boolean errorOnInteract = true;
    private boolean accessControl = true;
    private boolean echoCommand;
    private Integer commandTimeout;
    private boolean outputJSON;
    private boolean colorOutput;
    private ColorConfigImpl colorConfig;
    private boolean outputPaging = true;

    static CliConfig newBootConfig(boolean echoCommand) throws CliInitializationException {
        CliConfigImpl config = new CliConfigImpl();
        config.validateOperationRequests = false;
        config.echoCommand = echoCommand;
        return config;
    }

    static CliConfig load(CommandContext ctx) throws CliInitializationException {
        return CliConfigImpl.load(ctx, null);
    }

    static CliConfig load(CommandContext ctx, CommandContextConfiguration configuration) throws CliInitializationException {
        File jbossCliFile = CliConfigImpl.findCLIFileFromSystemProperty();
        if (jbossCliFile == null) {
            jbossCliFile = CliConfigImpl.findCLIFileInCurrentDirectory();
        }
        if (jbossCliFile == null) {
            jbossCliFile = CliConfigImpl.findCLIFileInJBossHome();
        }
        CliConfigImpl config = null;
        if (jbossCliFile == null) {
            System.err.println("WARN: can't find jboss-cli.xml. Using default configuration values.");
            config = new CliConfigImpl();
        } else {
            config = CliConfigImpl.parse(ctx, jbossCliFile);
        }
        if (configuration != null) {
            config = CliConfigImpl.overrideConfigWithArguments(config, configuration);
        }
        return config;
    }

    private static File findCLIFileFromSystemProperty() {
        String jbossCliConfig = WildFlySecurityManager.getPropertyPrivileged(JBOSS_XML_CONFIG, null);
        if (jbossCliConfig == null) {
            return null;
        }
        return new File(jbossCliConfig);
    }

    private static File findCLIFileInCurrentDirectory() {
        String currentDir = WildFlySecurityManager.getPropertyPrivileged(CURRENT_WORKING_DIRECTORY, null);
        if (currentDir == null) {
            return null;
        }
        File jbossCliFile = new File(currentDir, JBOSS_CLI_FILE);
        if (!jbossCliFile.exists()) {
            return null;
        }
        return jbossCliFile;
    }

    private static File findCLIFileInJBossHome() {
        String jbossHome = WildFlySecurityManager.getEnvPropertyPrivileged("JBOSS_HOME", null);
        if (jbossHome == null) {
            return null;
        }
        File jbossCliFile = new File(jbossHome + File.separatorChar + "bin", JBOSS_CLI_FILE);
        if (!jbossCliFile.exists()) {
            return null;
        }
        return jbossCliFile;
    }

    private static CliConfigImpl parse(CommandContext ctx, File f) throws CliInitializationException {
        if (f == null) {
            throw new CliInitializationException("The file argument is null.");
        }
        if (!f.exists()) {
            return new CliConfigImpl();
        }
        CliConfigImpl config = new CliConfigImpl();
        BufferedInputStream input = null;
        try {
            XMLMapper mapper = XMLMapper.Factory.create();
            CliConfigReader reader = new CliConfigReader();
            for (Namespace current : Namespace.cliValues()) {
                mapper.registerRootElement(new QName(current.getUriString(), JBOSS_CLI), reader);
            }
            FileInputStream is = new FileInputStream(f);
            input = new BufferedInputStream(is);
            XMLStreamReader streamReader = XMLInputFactoryUtil.create().createXMLStreamReader(input);
            mapper.parseDocument(config, streamReader);
            streamReader.close();
        }
        catch (Throwable t) {
            try {
                throw new CliInitializationException("Failed to parse " + f.getAbsolutePath(), t);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
        }
        StreamUtils.safeClose(input);
        return config;
    }

    private static CliConfigImpl overrideConfigWithArguments(CliConfigImpl cliConfig, CommandContextConfiguration configuration) {
        cliConfig.connectionTimeout = configuration.getConnectionTimeout() != -1 ? configuration.getConnectionTimeout() : cliConfig.getConnectionTimeout();
        cliConfig.silent = configuration.isSilent() ? configuration.isSilent() : cliConfig.silent;
        cliConfig.errorOnInteract = configuration.isErrorOnInteract() != null ? configuration.isErrorOnInteract() : cliConfig.errorOnInteract;
        cliConfig.echoCommand = configuration.isEchoCommand() ? configuration.isEchoCommand() : cliConfig.echoCommand;
        cliConfig.commandTimeout = configuration.getCommandTimeout() != null ? configuration.getCommandTimeout() : cliConfig.commandTimeout;
        cliConfig.validateOperationRequests = configuration.isValidateOperationRequests() != null ? configuration.isValidateOperationRequests() : cliConfig.validateOperationRequests;
        cliConfig.outputJSON = configuration.isOutputJSON() ? configuration.isOutputJSON() : cliConfig.isOutputJSON();
        cliConfig.outputPaging = !configuration.isOutputPaging() ? configuration.isOutputPaging() : cliConfig.isOutputPaging();
        boolean bl = cliConfig.resolveParameterValues = configuration.isResolveParameterValues() ? configuration.isResolveParameterValues() : cliConfig.resolveParameterValues;
        if (!configuration.isColorOutput()) {
            cliConfig.colorOutput = false;
        } else if (configuration.isColorOutput() && cliConfig.colorConfig == null) {
            cliConfig.colorOutput = true;
        } else if (configuration.isColorOutput() && cliConfig.colorConfig != null) {
            cliConfig.colorOutput = cliConfig.isColorOutput();
        }
        return cliConfig;
    }

    private static String resolveString(String str) throws XMLStreamException {
        if (str == null) {
            return null;
        }
        if (str.startsWith("${") && str.endsWith("}")) {
            String resolved = WildFlySecurityManager.getPropertyPrivileged(str = str.substring(2, str.length() - 1), null);
            if (resolved == null) {
                throw new XMLStreamException("Failed to resolve '" + str + "' to a non-null value.");
            }
            str = resolved;
        }
        return str;
    }

    private static boolean resolveBoolean(String str) throws XMLStreamException {
        return Boolean.parseBoolean(CliConfigImpl.resolveString(str));
    }

    private static int resolveInteger(String str) throws XMLStreamException {
        return Integer.parseInt(CliConfigImpl.resolveString(str));
    }

    private CliConfigImpl() {
    }

    @Override
    public String getDefaultControllerProtocol() {
        return this.defaultControllerProtocol;
    }

    @Override
    public boolean isUseLegacyOverride() {
        return this.useLegacyOverride;
    }

    @Override
    @Deprecated
    public String getDefaultControllerHost() {
        return this.getDefaultControllerAddress().getHost();
    }

    @Override
    @Deprecated
    public int getDefaultControllerPort() {
        return this.getDefaultControllerAddress().getPort();
    }

    @Override
    public ControllerAddress getDefaultControllerAddress() {
        return this.defaultController;
    }

    @Override
    public ControllerAddress getAliasedControllerAddress(String alias) {
        return this.controllerAliases.get(alias);
    }

    @Override
    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    @Override
    public String getHistoryFileName() {
        return this.historyFileName;
    }

    @Override
    public String getHistoryFileDir() {
        return this.historyFileDir;
    }

    @Override
    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public boolean isValidateOperationRequests() {
        return this.validateOperationRequests;
    }

    @Override
    public boolean isResolveParameterValues() {
        return this.resolveParameterValues;
    }

    @Override
    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public boolean isErrorOnInteract() {
        return this.errorOnInteract;
    }

    @Override
    public boolean isAccessControl() {
        return this.accessControl;
    }

    @Override
    public boolean isEchoCommand() {
        return this.echoCommand;
    }

    @Override
    public Integer getCommandTimeout() {
        return this.commandTimeout;
    }

    @Override
    public boolean isOutputJSON() {
        return this.outputJSON;
    }

    @Override
    public boolean isColorOutput() {
        return this.colorOutput;
    }

    @Override
    public ColorConfig getColorConfig() {
        return this.colorConfig;
    }

    @Override
    public boolean isOutputPaging() {
        return this.outputPaging;
    }

    static class CliConfigReader
    implements XMLElementReader<CliConfigImpl> {
        CliConfigReader() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, CliConfigImpl config) throws XMLStreamException {
            String localName = reader.getLocalName();
            if (!CliConfigImpl.JBOSS_CLI.equals(localName)) {
                throw new XMLStreamException("Unexpected element: " + localName);
            }
            Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
            for (Namespace current : Namespace.cliValues()) {
                if (!readerNS.equals((Object)current)) continue;
                switch (readerNS) {
                    case CLI_1_0: {
                        this.readCLIElement_1_0(reader, readerNS, config);
                        break;
                    }
                    case CLI_1_1: {
                        this.readCLIElement_1_1(reader, readerNS, config);
                        break;
                    }
                    case CLI_1_2: 
                    case CLI_1_3: {
                        this.readCLIElement_1_2(reader, readerNS, config);
                        break;
                    }
                    case CLI_2_0: {
                        this.readCLIElement_2_0(reader, readerNS, config);
                        break;
                    }
                    case CLI_3_0: {
                        this.readCLIElement_3_0(reader, readerNS, config);
                        break;
                    }
                    case CLI_3_1: {
                        this.readCLIElement_3_1(reader, readerNS, config);
                        break;
                    }
                    case CLI_3_2: {
                        this.readCLIElement_3_2(reader, readerNS, config);
                        break;
                    }
                    case CLI_3_3: {
                        this.readCLIElement_3_3(reader, readerNS, config);
                        break;
                    }
                    case CLI_3_4: {
                        this.readCLIElement_3_4(reader, readerNS, config);
                        break;
                    }
                    default: {
                        this.readCLIElement_4_0(reader, readerNS, config);
                    }
                }
                return;
            }
            throw new XMLStreamException("Unexpected element: " + localName);
        }

        public void readCLIElement_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_1_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_1_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_1_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_1_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_1_2(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_1_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        if (expectedNs == Namespace.CLI_1_2) {
                            this.readSSLElement_1_1(reader, expectedNs, sslConfig);
                        } else {
                            this.readSSLElement_3_0(reader, expectedNs, sslConfig);
                        }
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_PROTOCOL)) {
                        this.readDefaultProtocol_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.CONTROLLERS)) {
                        this.readControllers_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_2_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ACCESS_CONTROL)) {
                        config.accessControl = CliConfigImpl.resolveBoolean(reader.getElementText());
                        CliConfigReader.logAccessControl(config.accessControl);
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_3_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_PROTOCOL)) {
                        this.readDefaultProtocol_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.CONTROLLERS)) {
                        this.readControllers_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_3_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ACCESS_CONTROL)) {
                        config.accessControl = CliConfigImpl.resolveBoolean(reader.getElementText());
                        CliConfigReader.logAccessControl(config.accessControl);
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_3_1(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_PROTOCOL)) {
                        this.readDefaultProtocol_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.CONTROLLERS)) {
                        this.readControllers_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ECHO_COMMAND)) {
                        config.echoCommand = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COMMAND_TIMEOUT)) {
                        config.commandTimeout = CliConfigImpl.resolveInteger(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_3_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ACCESS_CONTROL)) {
                        config.accessControl = CliConfigImpl.resolveBoolean(reader.getElementText());
                        CliConfigReader.logAccessControl(config.accessControl);
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_3_2(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_PROTOCOL)) {
                        this.readDefaultProtocol_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.CONTROLLERS)) {
                        this.readControllers_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ECHO_COMMAND)) {
                        config.echoCommand = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.OUTPUT_JSON)) {
                        config.outputJSON = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COMMAND_TIMEOUT)) {
                        config.commandTimeout = CliConfigImpl.resolveInteger(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_3_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ACCESS_CONTROL)) {
                        config.accessControl = CliConfigImpl.resolveBoolean(reader.getElementText());
                        CliConfigReader.logAccessControl(config.accessControl);
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_3_3(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_PROTOCOL)) {
                        this.readDefaultProtocol_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.CONTROLLERS)) {
                        this.readControllers_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ECHO_COMMAND)) {
                        config.echoCommand = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.OUTPUT_JSON)) {
                        config.outputJSON = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COLOR_OUTPUT)) {
                        ColorConfigImpl colorConfig = new ColorConfigImpl();
                        this.readColorElement_3_3(reader, expectedNs, colorConfig);
                        config.colorConfig = colorConfig;
                        config.colorOutput = colorConfig.isEnabled();
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COMMAND_TIMEOUT)) {
                        config.commandTimeout = CliConfigImpl.resolveInteger(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_3_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ACCESS_CONTROL)) {
                        config.accessControl = CliConfigImpl.resolveBoolean(reader.getElementText());
                        CliConfigReader.logAccessControl(config.accessControl);
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        public void readCLIElement_3_4(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_PROTOCOL)) {
                        this.readDefaultProtocol_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.CONTROLLERS)) {
                        this.readControllers_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ECHO_COMMAND)) {
                        config.echoCommand = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.OUTPUT_JSON)) {
                        config.outputJSON = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COLOR_OUTPUT)) {
                        ColorConfigImpl colorConfig = new ColorConfigImpl();
                        this.readColorElement_3_3(reader, expectedNs, colorConfig);
                        config.colorConfig = colorConfig;
                        config.colorOutput = colorConfig.isEnabled();
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COMMAND_TIMEOUT)) {
                        config.commandTimeout = CliConfigImpl.resolveInteger(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_3_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ACCESS_CONTROL)) {
                        config.accessControl = CliConfigImpl.resolveBoolean(reader.getElementText());
                        CliConfigReader.logAccessControl(config.accessControl);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.OUTPUT_PAGING)) {
                        config.outputPaging = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        void readCLIElement_4_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_PROTOCOL)) {
                        this.readDefaultProtocol_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        this.readDefaultController_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.CONTROLLERS)) {
                        this.readControllers_2_0(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ECHO_COMMAND)) {
                        config.echoCommand = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.OUTPUT_JSON)) {
                        config.outputJSON = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COLOR_OUTPUT)) {
                        ColorConfigImpl colorConfig = new ColorConfigImpl();
                        this.readColorElement_3_3(reader, expectedNs, colorConfig);
                        config.colorConfig = colorConfig;
                        config.colorOutput = colorConfig.isEnabled();
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.COMMAND_TIMEOUT)) {
                        config.commandTimeout = CliConfigImpl.resolveInteger(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        this.readSSLElement_3_0(reader, expectedNs, sslConfig);
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.ACCESS_CONTROL)) {
                        config.accessControl = CliConfigImpl.resolveBoolean(reader.getElementText());
                        CliConfigReader.logAccessControl(config.accessControl);
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.OUTPUT_PAGING)) {
                        config.outputPaging = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        private void readDefaultProtocol_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            int attributes = reader.getAttributeCount();
            for (int i = 0; i < attributes; ++i) {
                String namespace = reader.getAttributeNamespace(i);
                String localName = reader.getAttributeLocalName(i);
                String value = reader.getAttributeValue(i);
                if (namespace != null && !namespace.equals("")) {
                    throw new XMLStreamException("Unexpected attribute '" + namespace + ":" + localName + "'", reader.getLocation());
                }
                if (!localName.equals(CliConfigImpl.USE_LEGACY_OVERRIDE)) {
                    throw new XMLStreamException("Unexpected attribute '" + localName + "'", reader.getLocation());
                }
                config.useLegacyOverride = Boolean.parseBoolean(value);
            }
            String resolved = CliConfigImpl.resolveString(reader.getElementText());
            if (resolved != null && resolved.length() > 0) {
                config.defaultControllerProtocol = resolved;
            }
        }

        private void readDefaultController_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            config.defaultController = this.readController(false, reader, expectedNs);
        }

        private void readDefaultController_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            config.defaultController = this.readController(true, reader, expectedNs);
        }

        private ControllerAddress readController(boolean allowProtocol, XMLExtendedStreamReader reader, Namespace expectedNs) throws XMLStreamException {
            String protocol = null;
            String host = null;
            int port = -1;
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                String resolved = CliConfigImpl.resolveString(reader.getElementText());
                if (CliConfigImpl.HOST.equals(localName) && host == null) {
                    host = resolved;
                    continue;
                }
                if (CliConfigImpl.PROTOCOL.equals(localName) && protocol == null && allowProtocol) {
                    protocol = resolved;
                    continue;
                }
                if (CliConfigImpl.PORT.equals(localName) && port < 0) {
                    try {
                        port = Integer.parseInt(resolved);
                        if (port >= 0) continue;
                        throw new XMLStreamException("Invalid negative port \"" + resolved + "\"");
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException("Failed to parse default-controller port value '" + resolved + "'", e);
                    }
                }
                throw new XMLStreamException("Unexpected child of default-controller: " + localName);
            }
            return new ControllerAddress(protocol, host == null ? "localhost" : host, port);
        }

        private void readControllers_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            HashMap<String, ControllerAddress> aliasedAddresses = new HashMap<String, ControllerAddress>();
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if (CliConfigImpl.CONTROLLER.equals(localName)) {
                    String name = null;
                    int attributes = reader.getAttributeCount();
                    for (int i = 0; i < attributes; ++i) {
                        String namespace = reader.getAttributeNamespace(i);
                        String attrLocalName = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (namespace != null && !namespace.equals("")) {
                            throw new XMLStreamException("Unexpected attribute '" + namespace + ":" + attrLocalName + "'", reader.getLocation());
                        }
                        if (!attrLocalName.equals(CliConfigImpl.NAME) || name != null) {
                            throw new XMLStreamException("Unexpected attribute '" + attrLocalName + "'", reader.getLocation());
                        }
                        name = value;
                    }
                    if (name == null) {
                        throw new XMLStreamException("Missing required attribute 'name'", reader.getLocation());
                    }
                    aliasedAddresses.put(name, this.readController(true, reader, expectedNs));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of controller: " + localName);
            }
            config.controllerAliases = Collections.unmodifiableMap(aliasedAddresses);
        }

        private void readHistory(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                String resolved = CliConfigImpl.resolveString(reader.getElementText());
                if (CliConfigImpl.ENABLED.equals(localName)) {
                    config.historyEnabled = Boolean.parseBoolean(resolved);
                    continue;
                }
                if (CliConfigImpl.FILE_NAME.equals(localName)) {
                    config.historyFileName = resolved;
                    continue;
                }
                if (CliConfigImpl.FILE_DIR.equals(localName)) {
                    config.historyFileDir = resolved;
                    continue;
                }
                if (CliConfigImpl.MAX_SIZE.equals(localName)) {
                    try {
                        config.historyMaxSize = Integer.parseInt(resolved);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException("Failed to parse history max-size value '" + resolved + "'", e);
                    }
                }
                throw new XMLStreamException("Unexpected child of default-controller: " + localName);
            }
        }

        public void readSSLElement_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, SslConfig config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if ("keyStore".equals(localName)) {
                    config.setKeyStore(reader.getElementText());
                    continue;
                }
                if ("keyStorePassword".equals(localName)) {
                    config.setKeyStorePassword(reader.getElementText());
                    continue;
                }
                if ("trustStore".equals(localName)) {
                    config.setTrustStore(reader.getElementText());
                    continue;
                }
                if ("trustStorePassword".equals(localName)) {
                    config.setTrustStorePassword(reader.getElementText());
                    continue;
                }
                if ("modifyTrustStore".equals(localName)) {
                    config.setModifyTrustStore(CliConfigImpl.resolveBoolean(reader.getElementText()));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of ssl : " + localName);
            }
        }

        public void readSSLElement_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, SslConfig config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if ("alias".equals(localName)) {
                    config.setAlias(reader.getElementText());
                    continue;
                }
                if ("key-store".equals(localName) || "keyStore".equals(localName)) {
                    config.setKeyStore(reader.getElementText());
                    continue;
                }
                if ("key-store-password".equals(localName) || "keyStorePassword".equals(localName)) {
                    config.setKeyStorePassword(reader.getElementText());
                    continue;
                }
                if ("key-password".equals(localName) || "keyPassword".equals(localName)) {
                    config.setKeyPassword(reader.getElementText());
                    continue;
                }
                if ("trust-store".equals(localName) || "trustStore".equals(localName)) {
                    config.setTrustStore(reader.getElementText());
                    continue;
                }
                if ("trust-store-password".equals(localName) || "trustStorePassword".equals(localName)) {
                    config.setTrustStorePassword(reader.getElementText());
                    continue;
                }
                if ("modify-trust-store".equals(localName) || "modifyTrustStore".equals(localName)) {
                    config.setModifyTrustStore(CliConfigImpl.resolveBoolean(reader.getElementText()));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of ssl : " + localName);
            }
        }

        public void readSSLElement_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, SslConfig config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if ("vault".equals(localName)) {
                    throw new XMLStreamException("Vault support has been removed, please remove the <vault /> configuration.");
                }
                if ("alias".equals(localName)) {
                    config.setAlias(reader.getElementText());
                    continue;
                }
                if ("key-store".equals(localName) || "keyStore".equals(localName)) {
                    config.setKeyStore(reader.getElementText());
                    continue;
                }
                if ("key-store-password".equals(localName) || "keyStorePassword".equals(localName)) {
                    config.setKeyStorePassword(this.getPassword("key-store-password", reader.getElementText()));
                    continue;
                }
                if ("key-password".equals(localName) || "keyPassword".equals(localName)) {
                    config.setKeyPassword(this.getPassword("key-password", reader.getElementText()));
                    continue;
                }
                if ("trust-store".equals(localName) || "trustStore".equals(localName)) {
                    config.setTrustStore(reader.getElementText());
                    continue;
                }
                if ("trust-store-password".equals(localName) || "trustStorePassword".equals(localName)) {
                    config.setTrustStorePassword(this.getPassword("trust-store-password", reader.getElementText()));
                    continue;
                }
                if ("modify-trust-store".equals(localName) || "modifyTrustStore".equals(localName)) {
                    config.setModifyTrustStore(CliConfigImpl.resolveBoolean(reader.getElementText()));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of ssl : " + localName);
            }
        }

        public void readSSLElement_3_0(XMLExtendedStreamReader reader, Namespace expectedNs, SslConfig config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if ("vault".equals(localName)) {
                    throw new XMLStreamException("Vault support has been removed, please remove the <vault /> configuration.");
                }
                if ("alias".equals(localName)) {
                    config.setAlias(reader.getElementText());
                    continue;
                }
                if ("key-store".equals(localName) || "keyStore".equals(localName)) {
                    config.setKeyStore(reader.getElementText());
                    continue;
                }
                if ("key-store-password".equals(localName) || "keyStorePassword".equals(localName)) {
                    config.setKeyStorePassword(this.getPassword("key-store-password", reader.getElementText()));
                    continue;
                }
                if ("key-password".equals(localName) || "keyPassword".equals(localName)) {
                    config.setKeyPassword(this.getPassword("key-password", reader.getElementText()));
                    continue;
                }
                if ("trust-store".equals(localName) || "trustStore".equals(localName)) {
                    config.setTrustStore(reader.getElementText());
                    continue;
                }
                if ("trust-store-password".equals(localName) || "trustStorePassword".equals(localName)) {
                    config.setTrustStorePassword(this.getPassword("trust-store-password", reader.getElementText()));
                    continue;
                }
                if ("modify-trust-store".equals(localName) || "modifyTrustStore".equals(localName)) {
                    config.setModifyTrustStore(CliConfigImpl.resolveBoolean(reader.getElementText()));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of ssl : " + localName);
            }
        }

        void readSSLElement_4_0(XMLExtendedStreamReader reader, Namespace expectedNs, SslConfig config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if ("alias".equals(localName)) {
                    config.setAlias(reader.getElementText());
                    continue;
                }
                if ("key-store".equals(localName) || "keyStore".equals(localName)) {
                    config.setKeyStore(reader.getElementText());
                    continue;
                }
                if ("key-store-password".equals(localName) || "keyStorePassword".equals(localName)) {
                    config.setKeyStorePassword(this.getPassword("key-store-password", reader.getElementText()));
                    continue;
                }
                if ("key-password".equals(localName) || "keyPassword".equals(localName)) {
                    config.setKeyPassword(this.getPassword("key-password", reader.getElementText()));
                    continue;
                }
                if ("trust-store".equals(localName) || "trustStore".equals(localName)) {
                    config.setTrustStore(reader.getElementText());
                    continue;
                }
                if ("trust-store-password".equals(localName) || "trustStorePassword".equals(localName)) {
                    config.setTrustStorePassword(this.getPassword("trust-store-password", reader.getElementText()));
                    continue;
                }
                if ("modify-trust-store".equals(localName) || "modifyTrustStore".equals(localName)) {
                    config.setModifyTrustStore(CliConfigImpl.resolveBoolean(reader.getElementText()));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of ssl : " + localName);
            }
        }

        public void readColorElement_3_3(XMLExtendedStreamReader reader, Namespace expectedNs, ColorConfigImpl config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                try {
                    if (CliConfigImpl.ENABLED.equals(localName)) {
                        config.setEnabled(CliConfigImpl.resolveBoolean(reader.getElementText()));
                        continue;
                    }
                    if ("error-color".equals(localName)) {
                        config.setErrorColor(config.convertColor(reader.getElementText()));
                        continue;
                    }
                    if ("warn-color".equals(localName)) {
                        config.setWarnColor(config.convertColor(reader.getElementText()));
                        continue;
                    }
                    if ("success-color".equals(localName)) {
                        config.setSuccessColor(config.convertColor(reader.getElementText()));
                        continue;
                    }
                    if ("required-color".equals(localName)) {
                        config.setRequiredColor(config.convertColor(reader.getElementText()));
                        continue;
                    }
                    if ("workflow-color".equals(localName)) {
                        config.setBatchColor(config.convertColor(reader.getElementText()));
                        continue;
                    }
                    if ("prompt-color".equals(localName)) {
                        config.setPromptColor(config.convertColor(reader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unexpected child of color-output: " + localName);
                }
                catch (CliInitializationException ciex) {
                    throw new XMLStreamException("Error parsing color-output", ciex);
                }
            }
        }

        private String getPassword(String element, String str) throws XMLStreamException {
            if (VAULT_PATTERN.matcher(str).matches()) {
                log.warnf("Unexpected vault expression for '%s'.", (Object)element);
            }
            return CLIExpressionResolver.resolveOrOriginal(str);
        }

        static void assertExpectedNamespace(XMLExtendedStreamReader reader, Namespace expectedNs) throws XMLStreamException {
            if (!expectedNs.equals((Object)Namespace.forUri(reader.getNamespaceURI()))) {
                CliConfigReader.unexpectedElement(reader);
            }
        }

        static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
            if (reader.hasNext() && reader.nextTag() != 2) {
                CliConfigReader.unexpectedElement(reader);
            }
        }

        static void unexpectedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            throw new XMLStreamException("Unexpected element " + String.valueOf(reader.getName()) + " at " + String.valueOf(reader.getLocation()));
        }

        private static void logAccessControl(boolean accessControl) {
            if (log.isTraceEnabled()) {
                log.trace("access-control is " + accessControl);
            }
        }
    }

    static class ColorConfigImpl
    implements ColorConfig {
        private boolean enabled = false;
        private Color errorColor;
        private Color warnColor;
        private Color successColor;
        private Color requiredColor;
        private Color batchColor;
        private Color promptColor;

        ColorConfigImpl() {
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Color getErrorColor() {
            return this.errorColor;
        }

        public void setErrorColor(Color errorColor) {
            this.errorColor = errorColor;
        }

        @Override
        public Color getWarnColor() {
            return this.warnColor;
        }

        public void setWarnColor(Color warnColor) {
            this.warnColor = warnColor;
        }

        @Override
        public Color getSuccessColor() {
            return this.successColor;
        }

        public void setSuccessColor(Color successColor) {
            this.successColor = successColor;
        }

        @Override
        public Color getRequiredColor() {
            return this.requiredColor;
        }

        public void setBatchColor(Color batchColor) {
            this.batchColor = batchColor;
        }

        @Override
        public Color getWorkflowColor() {
            return this.batchColor;
        }

        @Override
        public Color getPromptColor() {
            return this.promptColor;
        }

        public void setPromptColor(Color promptColor) {
            this.promptColor = promptColor;
        }

        public void setRequiredColor(Color requiredColor) {
            this.requiredColor = requiredColor;
        }

        public Color convertColor(String name) throws CliInitializationException {
            switch (name.toLowerCase(Locale.ENGLISH)) {
                case "black": {
                    return Color.BLACK;
                }
                case "red": {
                    return Color.RED;
                }
                case "green": {
                    return Color.GREEN;
                }
                case "yellow": {
                    return Color.YELLOW;
                }
                case "blue": {
                    return Color.BLUE;
                }
                case "magenta": {
                    return Color.MAGENTA;
                }
                case "cyan": {
                    return Color.CYAN;
                }
                case "white": {
                    return Color.WHITE;
                }
                case "default": {
                    return Color.DEFAULT;
                }
            }
            throw new CliInitializationException("Invalid color \"" + name + "\".");
        }
    }

    static class SslConfig
    implements SSLConfig {
        private String alias = null;
        private String keyStore = null;
        private String keyStorePassword = null;
        private String keyPassword = null;
        private String trustStore = null;
        private String trustStorePassword = null;
        private boolean modifyTrustStore = true;

        SslConfig() {
        }

        @Override
        public String getKeyStore() {
            return this.keyStore;
        }

        void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        @Override
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public String getKeyPassword() {
            return this.keyPassword;
        }

        void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        @Override
        public String getTrustStore() {
            return this.trustStore;
        }

        void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        @Override
        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        @Override
        public boolean isModifyTrustStore() {
            return this.modifyTrustStore;
        }

        void setModifyTrustStore(boolean modifyTrustStore) {
            this.modifyTrustStore = modifyTrustStore;
        }
    }
}

