/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.util.Map;
import org.wildfly.clustering.cache.function.MapFunction;
import org.wildfly.clustering.cache.function.MapOperations;

public class MapComputeFunction<K, V>
extends MapFunction<K, V, Map<K, V>> {
    public MapComputeFunction(Map<K, V> operand) {
        super(operand, MapOperations.forOperandKey(operand.keySet().iterator().next()));
    }

    @Override
    public void accept(Map<K, V> map, Map<K, V> operand) {
        for (Map.Entry<K, V> entry : operand.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (value != null) {
                map.put(key, value);
                continue;
            }
            map.remove(key);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MapComputeFunction)) {
            return false;
        }
        MapComputeFunction function = (MapComputeFunction)object;
        Map ourOperand = (Map)this.getOperand();
        Map otherOperand = (Map)function.getOperand();
        return ourOperand.size() == otherOperand.size() && ourOperand.keySet().containsAll(otherOperand.keySet()) && ourOperand.equals(otherOperand);
    }
}

