/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.cache.function.Operations;

public enum MapOperations implements Operations<Map<Object, Object>>
{
    HASH(HashMap::new, HashMap::new),
    TREE(TreeMap::new, TreeMap::new);

    private final Supplier<Map<Object, Object>> factory;
    private final UnaryOperator<Map<Object, Object>> copier;

    static <K, V> Operations<Map<K, V>> forOperandKey(K value) {
        MapOperations result = value instanceof Comparable ? TREE : HASH;
        return result.cast();
    }

    private MapOperations(Supplier<Map<Object, Object>> factory, UnaryOperator<Map<Object, Object>> copier) {
        this.factory = factory;
        this.copier = copier;
    }

    @Override
    public UnaryOperator<Map<Object, Object>> getCopier() {
        return this.copier;
    }

    @Override
    public Supplier<Map<Object, Object>> getFactory() {
        return this.factory;
    }

    @Override
    public Predicate<Map<Object, Object>> isEmpty() {
        return Map::isEmpty;
    }

    <K, V> Operations<Map<K, V>> cast() {
        return this;
    }
}

