/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.PlatformLoggingMXBean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformLoggingResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

class PlatformLoggingMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final PlatformLoggingMXBeanAttributeHandler INSTANCE = new PlatformLoggingMXBeanAttributeHandler();

    private PlatformLoggingMXBeanAttributeHandler() {
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        throw PlatformLoggingMXBeanAttributeHandler.unknownAttribute(operation);
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = operation.require("name").asString();
        try {
            if (!PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) && !PlatformLoggingResourceDefinition.PLATFORM_LOGGING_READ_ATTRIBUTES.contains(name)) {
                throw PlatformLoggingMXBeanAttributeHandler.unknownAttribute(operation);
            }
            PlatformLoggingMXBeanAttributeHandler.storeResult(name, context.getResult());
        }
        catch (SecurityException | UnsupportedOperationException e) {
            throw new OperationFailedException(e.toString());
        }
    }

    static void storeResult(String name, ModelNode store) {
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            store.set("java.util.logging:type=Logging");
        } else if ("logger-names".equals(name)) {
            store.setEmptyList();
            for (String loggerName : ManagementFactory.getPlatformMXBean(PlatformLoggingMXBean.class).getLoggerNames()) {
                store.add(loggerName);
            }
        } else if (PlatformLoggingResourceDefinition.PLATFORM_LOGGING_READ_ATTRIBUTES.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }
}

