/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v62.impl;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.v62.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v62.impl.BaseRegionImpl;

public class TimestampsRegionImpl
extends BaseRegionImpl
implements TimestampsRegion {
    private final AdvancedCache timestampsPutCache;

    public TimestampsRegionImpl(AdvancedCache cache, String name, InfinispanRegionFactory factory) {
        super(cache, name, factory);
        this.timestampsPutCache = this.getTimestampsPutCache(cache);
    }

    protected AdvancedCache getTimestampsPutCache(AdvancedCache cache) {
        return Caches.ignoreReturnValuesCache((AdvancedCache)cache, (Flag)Flag.SKIP_LOCKING);
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        if (this.checkValid()) {
            return this.cache.get(key);
        }
        return null;
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        try {
            this.timestampsPutCache.put(key, value);
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

