/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingEnvironment;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingEntityIdentifierLoadingRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingEntityLoadingRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingFailureHandledRunnable;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeGroup;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingNotifier;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoProducerConsumerQueue;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingMappingContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMassIndexingBatchIndexingWorkspace<E, I>
extends PojoMassIndexingFailureHandledRunnable {
    public static final String THREAD_NAME_PREFIX = "Mass indexing - ";
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<CompletableFuture<?>> identifierProducingFutures = new ArrayList();
    private final List<CompletableFuture<?>> indexingFutures = new ArrayList();
    private final PojoMassIndexingMappingContext mappingContext;
    private final PojoMassIndexingIndexedTypeGroup<E> typeGroup;
    private final PojoMassLoadingStrategy<E, I> loadingStrategy;
    private final PojoMassIndexingContext massIndexingContext;
    private final int entityExtractingThreads;
    private final String tenantId;

    PojoMassIndexingBatchIndexingWorkspace(PojoMassIndexingMappingContext mappingContext, PojoMassIndexingNotifier notifier, MassIndexingEnvironment environment, PojoMassIndexingIndexedTypeGroup<E> typeGroup, PojoMassLoadingStrategy<E, I> loadingStrategy, PojoMassIndexingContext massIndexingContext, int entityExtractingThreads, String tenantId) {
        super(notifier, environment);
        this.mappingContext = mappingContext;
        this.typeGroup = typeGroup;
        this.loadingStrategy = loadingStrategy;
        this.massIndexingContext = massIndexingContext;
        this.entityExtractingThreads = entityExtractingThreads;
        this.tenantId = tenantId;
    }

    @Override
    public void runWithFailureHandler() throws InterruptedException {
        if (!this.identifierProducingFutures.isEmpty() || !this.indexingFutures.isEmpty()) {
            throw new AssertionFailure("BatchIndexingWorkspace instance not expected to be reused");
        }
        PojoProducerConsumerQueue<List<I>> identifierQueue = new PojoProducerConsumerQueue<List<I>>(1);
        this.startIndexing(identifierQueue);
        this.startProducingPrimaryKeys(identifierQueue);
        ArrayList allFutures = new ArrayList();
        allFutures.addAll(this.identifierProducingFutures);
        allFutures.addAll(this.indexingFutures);
        Futures.unwrappedExceptionGet((Future)Futures.firstFailureOrAllOf(allFutures));
        log.debugf("Indexing for %s is done", this.typeGroup.notifiedGroupName());
    }

    @Override
    protected void cleanUpOnInterruption() {
        this.cancelPendingTasks();
    }

    @Override
    protected void cleanUpOnFailure() {
        this.cancelPendingTasks();
    }

    private void cancelPendingTasks() {
        for (Future future : this.identifierProducingFutures) {
            future.cancel(true);
        }
        for (Future future : this.indexingFutures) {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProducingPrimaryKeys(PojoProducerConsumerQueue<List<I>> identifierQueue) {
        PojoMassIndexingEntityIdentifierLoadingRunnable<E, I> runnable = new PojoMassIndexingEntityIdentifierLoadingRunnable<E, I>(this.getNotifier(), this.massIndexingContext, this.getMassIndexingEnvironment(), this.typeGroup, this.loadingStrategy, identifierQueue, this.tenantId);
        ThreadPoolExecutor identifierProducingExecutor = this.mappingContext.threadPoolProvider().newFixedThreadPool(1, THREAD_NAME_PREFIX + this.typeGroup.notifiedGroupName() + " - ID loading");
        try {
            this.identifierProducingFutures.add(Futures.runAsync(runnable, (ExecutorService)identifierProducingExecutor));
        }
        finally {
            identifierProducingExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIndexing(PojoProducerConsumerQueue<List<I>> identifierQueue) {
        PojoMassIndexingEntityLoadingRunnable<E, I> runnable = new PojoMassIndexingEntityLoadingRunnable<E, I>(this.getNotifier(), this.massIndexingContext, this.getMassIndexingEnvironment(), this.typeGroup, this.loadingStrategy, identifierQueue, this.tenantId);
        ThreadPoolExecutor indexingExecutor = this.mappingContext.threadPoolProvider().newFixedThreadPool(this.entityExtractingThreads, THREAD_NAME_PREFIX + this.typeGroup.notifiedGroupName() + " - Entity loading");
        try {
            for (int i = 0; i < this.entityExtractingThreads; ++i) {
                this.indexingFutures.add(Futures.runAsync(runnable, (ExecutorService)indexingExecutor));
            }
        }
        finally {
            indexingExecutor.shutdown();
        }
    }
}

