/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.jboss.resteasy.client.exception.WebApplicationExceptionWrapper;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class DefaultResponseExceptionMapper
implements ResponseExceptionMapper {
    private final boolean originalBehavior;
    private final boolean unwrappedExceptions;
    private final boolean serverSide;

    public DefaultResponseExceptionMapper() {
        Config config = ConfigProvider.getConfig();
        this.originalBehavior = config.getOptionalValue("resteasy.original.webapplicationexception.behavior", Boolean.TYPE).orElse(false);
        this.serverSide = ResteasyDeployment.onServer();
        this.unwrappedExceptions = config.getOptionalValue("resteasy.unwrapped.exceptions", Boolean.TYPE).orElse(false);
    }

    private static Function<Response, ServerErrorException> serverExceptionConstructor(int status) {
        switch (status) {
            case 500: {
                return InternalServerErrorException::new;
            }
            case 503: {
                return ServiceUnavailableException::new;
            }
        }
        return ServerErrorException::new;
    }

    private static Function<Response, ClientErrorException> clientExceptionConstructor(int status) {
        switch (status) {
            case 400: {
                return BadRequestException::new;
            }
            case 401: {
                return NotAuthorizedException::new;
            }
            case 403: {
                return ForbiddenException::new;
            }
            case 404: {
                return NotFoundException::new;
            }
            case 405: {
                return NotAllowedException::new;
            }
            case 406: {
                return NotAcceptableException::new;
            }
            case 415: {
                return NotSupportedException::new;
            }
        }
        return ClientErrorException::new;
    }

    private static Function<Response, ? extends WebApplicationException> webApplicationException(int status) {
        if (status < 600) {
            if (status >= 500) {
                return DefaultResponseExceptionMapper.serverExceptionConstructor(status);
            }
            if (status >= 400) {
                return DefaultResponseExceptionMapper.clientExceptionConstructor(status);
            }
            if (status >= 300) {
                return RedirectionException::new;
            }
        }
        return WebApplicationException::new;
    }

    public Throwable toThrowable(Response response) {
        try {
            response.bufferEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        WebApplicationException unwrapped = DefaultResponseExceptionMapper.webApplicationException(response.getStatus()).apply(response);
        return this.unwrappedExceptions ? unwrapped : WebApplicationExceptionWrapper.wrap((WebApplicationException)unwrapped);
    }

    public boolean handles(int status, MultivaluedMap headers) {
        return status >= (this.originalBehavior || !this.serverSide ? 400 : 300);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

