/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.metamodel.mapping.DiscriminatorConverter;
import org.hibernate.metamodel.mapping.DiscriminatorValueDetails;
import org.hibernate.metamodel.mapping.internal.DiscriminatorValueDetailsImpl;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class DefaultDiscriminatorConverter<O, R>
extends DiscriminatorConverter<O, R> {
    private final MappingMetamodelImplementor mappingMetamodel;

    public static <O, R> DefaultDiscriminatorConverter<O, R> fromMappingMetamodel(NavigableRole role, JavaType<O> domainJavaType, BasicType<R> underlyingJdbcMapping, MappingMetamodelImplementor mappingMetamodel) {
        return new DefaultDiscriminatorConverter<O, R>(role, domainJavaType, underlyingJdbcMapping.getJavaTypeDescriptor(), mappingMetamodel);
    }

    public DefaultDiscriminatorConverter(NavigableRole discriminatorRole, JavaType<O> domainJavaType, JavaType<R> relationalJavaType, MappingMetamodelImplementor mappingMetamodel) {
        super(discriminatorRole.getFullPath(), domainJavaType, relationalJavaType);
        this.mappingMetamodel = mappingMetamodel;
    }

    @Override
    public DiscriminatorValueDetails getDetailsForRelationalForm(R relationalForm) {
        return this.getDetailsForDiscriminatorValue(relationalForm);
    }

    @Override
    public DiscriminatorValueDetails getDetailsForEntityName(String entityName) {
        EntityPersister persister = this.mappingMetamodel.findEntityDescriptor(entityName);
        if (persister != null) {
            return new DiscriminatorValueDetailsImpl(entityName, persister);
        }
        throw new AssertionFailure("Unrecognized entity name: " + entityName);
    }

    @Override
    public DiscriminatorValueDetails getDetailsForDiscriminatorValue(Object value) {
        String entityName;
        EntityPersister persister;
        if (value instanceof String && (persister = this.mappingMetamodel.findEntityDescriptor(entityName = this.mappingMetamodel.getImportedName((String)value))) != null) {
            return new DiscriminatorValueDetailsImpl(entityName, persister);
        }
        throw new HibernateException("Unrecognized discriminator value: " + String.valueOf(value));
    }

    @Override
    public void forEachValueDetail(Consumer<DiscriminatorValueDetails> consumer) {
    }

    @Override
    public <X> X fromValueDetails(Function<DiscriminatorValueDetails, X> handler) {
        return null;
    }
}

