/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqJournalEnvironmentBean;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ArjunaObjectStoreEnvironmentService
implements Service {
    private final Consumer<Class<Void>> serviceConsumer;
    private final Supplier<PathManager> pathManagerSupplier;
    private final boolean useJournalStore;
    private final boolean enableAsyncIO;
    private final String path;
    private final String pathRef;
    private final boolean useJdbcStore;
    private final String dataSourceJndiName;
    private final JdbcStoreConfig jdbcSoreConfig;
    private volatile PathManager.Callback.Handle callbackHandle;

    public ArjunaObjectStoreEnvironmentService(Consumer<Class<Void>> serviceConsumer, Supplier<PathManager> pathManagerSupplier, boolean useJournalStore, boolean enableAsyncIO, String path, String pathRef, boolean useJdbcStore, String dataSourceJndiName, JdbcStoreConfig jdbcSoreConfig) {
        this.serviceConsumer = serviceConsumer;
        this.pathManagerSupplier = pathManagerSupplier;
        this.useJournalStore = useJournalStore;
        this.enableAsyncIO = enableAsyncIO;
        this.path = path;
        this.pathRef = pathRef;
        this.useJdbcStore = useJdbcStore;
        this.dataSourceJndiName = dataSourceJndiName;
        this.jdbcSoreConfig = jdbcSoreConfig;
    }

    public void start(StartContext context) throws StartException {
        this.callbackHandle = this.pathManagerSupplier.get().registerCallback(this.pathRef, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
        String objectStoreDir = this.pathManagerSupplier.get().resolveRelativePathEntry(this.path, this.pathRef);
        ObjectStoreEnvironmentBean defaultActionStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, null);
        if (this.useJournalStore) {
            HornetqJournalEnvironmentBean hornetqJournalEnvironmentBean = (HornetqJournalEnvironmentBean)BeanPopulator.getDefaultInstance(HornetqJournalEnvironmentBean.class);
            hornetqJournalEnvironmentBean.setAsyncIO(this.enableAsyncIO);
            hornetqJournalEnvironmentBean.setStoreDir(objectStoreDir + "/HornetqObjectStore");
            defaultActionStoreObjectStoreEnvironmentBean.setObjectStoreType("com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqObjectStoreAdaptor");
        } else {
            defaultActionStoreObjectStoreEnvironmentBean.setObjectStoreDir(objectStoreDir);
        }
        ObjectStoreEnvironmentBean stateStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"stateStore");
        stateStoreObjectStoreEnvironmentBean.setObjectStoreDir(objectStoreDir);
        ObjectStoreEnvironmentBean communicationStoreObjectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore");
        communicationStoreObjectStoreEnvironmentBean.setObjectStoreDir(objectStoreDir);
        if (this.useJdbcStore) {
            defaultActionStoreObjectStoreEnvironmentBean.setObjectStoreType("com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCStore");
            stateStoreObjectStoreEnvironmentBean.setObjectStoreType("com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCStore");
            communicationStoreObjectStoreEnvironmentBean.setObjectStoreType("com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCStore");
            defaultActionStoreObjectStoreEnvironmentBean.setJdbcAccess("com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors.DataSourceJDBCAccess;datasourceName=" + this.dataSourceJndiName);
            stateStoreObjectStoreEnvironmentBean.setJdbcAccess("com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors.DataSourceJDBCAccess;datasourceName=" + this.dataSourceJndiName);
            communicationStoreObjectStoreEnvironmentBean.setJdbcAccess("com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors.DataSourceJDBCAccess;datasourceName=" + this.dataSourceJndiName);
            defaultActionStoreObjectStoreEnvironmentBean.setTablePrefix(this.jdbcSoreConfig.getActionTablePrefix());
            stateStoreObjectStoreEnvironmentBean.setTablePrefix(this.jdbcSoreConfig.getStateTablePrefix());
            communicationStoreObjectStoreEnvironmentBean.setTablePrefix(this.jdbcSoreConfig.getCommunicationTablePrefix());
            defaultActionStoreObjectStoreEnvironmentBean.setDropTable(this.jdbcSoreConfig.isActionDropTable());
            stateStoreObjectStoreEnvironmentBean.setDropTable(this.jdbcSoreConfig.isStateDropTable());
            communicationStoreObjectStoreEnvironmentBean.setDropTable(this.jdbcSoreConfig.isCommunicationDropTable());
        }
        this.serviceConsumer.accept(Void.class);
    }

    public void stop(StopContext context) {
        this.callbackHandle.remove();
    }

    public static final class JdbcStoreConfig {
        private final String actionTablePrefix;
        private final boolean actionDropTable;
        private final String stateTablePrefix;
        private final boolean stateDropTable;
        private final String communicationTablePrefix;
        private final boolean communicationDropTable;

        private JdbcStoreConfig(String actionTablePrefix, boolean actionDropTable, String stateTablePrefix, boolean stateDropTable, String communicationTablePrefix, boolean communicationDropTable) {
            this.actionTablePrefix = actionTablePrefix;
            this.actionDropTable = actionDropTable;
            this.stateTablePrefix = stateTablePrefix;
            this.stateDropTable = stateDropTable;
            this.communicationTablePrefix = communicationTablePrefix;
            this.communicationDropTable = communicationDropTable;
        }

        public String getActionTablePrefix() {
            return this.actionTablePrefix;
        }

        public boolean isActionDropTable() {
            return this.actionDropTable;
        }

        public String getStateTablePrefix() {
            return this.stateTablePrefix;
        }

        public boolean isStateDropTable() {
            return this.stateDropTable;
        }

        public String getCommunicationTablePrefix() {
            return this.communicationTablePrefix;
        }

        public boolean isCommunicationDropTable() {
            return this.communicationDropTable;
        }
    }

    public static final class JdbcStoreConfigBulder {
        private String actionTablePrefix;
        private boolean actionDropTable;
        private String stateTablePrefix;
        private boolean stateDropTable;
        private String communicationTablePrefix;
        private boolean communicationDropTable;

        public JdbcStoreConfigBulder setActionTablePrefix(String actionTablePrefix) {
            this.actionTablePrefix = actionTablePrefix;
            return this;
        }

        public JdbcStoreConfigBulder setActionDropTable(boolean actionDropTable) {
            this.actionDropTable = actionDropTable;
            return this;
        }

        public JdbcStoreConfigBulder setStateTablePrefix(String stateTablePrefix) {
            this.stateTablePrefix = stateTablePrefix;
            return this;
        }

        public JdbcStoreConfigBulder setStateDropTable(boolean stateDropTable) {
            this.stateDropTable = stateDropTable;
            return this;
        }

        public JdbcStoreConfigBulder setCommunicationTablePrefix(String communicationTablePrefix) {
            this.communicationTablePrefix = communicationTablePrefix;
            return this;
        }

        public JdbcStoreConfigBulder setCommunicationDropTable(boolean communicationDropTable) {
            this.communicationDropTable = communicationDropTable;
            return this;
        }

        public JdbcStoreConfig build() {
            return new JdbcStoreConfig(this.actionTablePrefix, this.actionDropTable, this.stateTablePrefix, this.stateDropTable, this.communicationTablePrefix, this.communicationDropTable);
        }
    }
}

