/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.EnumSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.xml.XMLElementSchema;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentConfiguration;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentSchema;
import org.wildfly.extension.clustering.web.deployment.MutableDistributableWebDeploymentConfiguration;

public class DistributableWebDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    private static final String DISTRIBUTABLE_WEB_DEPLOYMENT_DESCRIPTOR = "WEB-INF/distributable-web.xml";
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private final XMLMapper mapper = XMLElementSchema.createXMLMapper(EnumSet.allOf(DistributableWebDeploymentSchema.class));

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        VirtualFile file;
        DeploymentUnit unit = context.getDeploymentUnit();
        if (!unit.hasAttachment(DistributableWebDeploymentDependencyProcessor.CONFIGURATION_KEY) && (file = ((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild(DISTRIBUTABLE_WEB_DEPLOYMENT_DESCRIPTOR)).exists()) {
            try {
                unit.putAttachment(DistributableWebDeploymentDependencyProcessor.CONFIGURATION_KEY, (Object)this.parse(unit, file.getPhysicalFile()));
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(DistributableWebDeploymentDependencyProcessor.CONFIGURATION_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private DistributableWebDeploymentConfiguration parse(DeploymentUnit unit, File file) throws DeploymentUnitProcessingException {
        try (FileReader reader = new FileReader(file);){
            MutableDistributableWebDeploymentConfiguration mutableDistributableWebDeploymentConfiguration;
            XMLStreamReader xmlReader = XML_INPUT_FACTORY.createXMLStreamReader(reader);
            try {
                MutableDistributableWebDeploymentConfiguration config = new MutableDistributableWebDeploymentConfiguration(unit);
                this.mapper.parseDocument((Object)config, xmlReader);
                mutableDistributableWebDeploymentConfiguration = config;
            }
            catch (Throwable throwable) {
                xmlReader.close();
                throw throwable;
            }
            xmlReader.close();
            return mutableDistributableWebDeploymentConfiguration;
        }
        catch (XMLStreamException e) {
            throw ServerLogger.ROOT_LOGGER.errorLoadingDeploymentStructureFile(file.getPath(), e);
        }
        catch (FileNotFoundException e) {
            throw ServerLogger.ROOT_LOGGER.deploymentStructureFileNotFound(file);
        }
        catch (IOException e) {
            throw ServerLogger.ROOT_LOGGER.deploymentStructureFileNotFound(file);
        }
    }
}

