/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.opentelemetry.api.OpenTelemetry;
import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.UnicastProcessor;
import io.smallrye.reactive.messaging.ClientCustomizer;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.KafkaCDIEvents;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.SerializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.api.OutgoingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.commit.ContextHolder;
import io.smallrye.reactive.messaging.kafka.commit.KafkaLatestCommit;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.ConfigHelper;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSink;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaConsumer;
import io.smallrye.reactive.messaging.providers.impl.OverrideConnectorConfig;
import io.smallrye.reactive.messaging.providers.wiring.Wiring;
import io.vertx.core.Context;
import io.vertx.core.impl.VertxInternal;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.StringSerializer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class KafkaDelayedRetryTopic
extends ContextHolder
implements KafkaFailureHandler {
    public static final String DELAYED_RETRY_TOPIC_STRATEGY = "delayed-retry-topic";
    public static final String DELAYED_RETRY_COUNT = "delayed-retry-count";
    public static final String DELAYED_RETRY_ORIGINAL_TIMESTAMP = "delayed-retry-original-timestamp";
    public static final String DELAYED_RETRY_FIRST_PROCESSING_TIMESTAMP = "delayed-retry-first-processing-timestamp";
    public static final String DELAYED_RETRY_EXCEPTION_CLASS_NAME = "delayed-retry-exception-class-name";
    public static final String DELAYED_RETRY_CAUSE_CLASS_NAME = "delayed-retry-cause-class-name";
    public static final String DELAYED_RETRY_REASON = "delayed-retry-reason";
    public static final String DELAYED_RETRY_CAUSE = "delayed-retry-cause";
    public static final String DELAYED_RETRY_TOPIC = "delayed-retry-topic";
    public static final String DELAYED_RETRY_OFFSET = "delayed-retry-offset";
    public static final String DELAYED_RETRY_PARTITION = "delayed-retry-partition";
    private final String channel;
    private final Vertx vertx;
    private final KafkaConnectorIncomingConfiguration configuration;
    private final String deadQueueTopic;
    private final UnicastProcessor<Message<?>> dlqSource;
    private final KafkaSink dlqSink;
    private final ReactiveKafkaConsumer consumer;
    private final List<String> retryTopics;
    private final int maxRetries;
    private final long retryTimeout;

    public KafkaDelayedRetryTopic(String channel, Vertx vertx, KafkaConnectorIncomingConfiguration configuration, List<String> retryTopics, int maxRetries, long retryTimeout, String deadQueueTopic, UnicastProcessor<Message<?>> dlqSource, KafkaSink dlqSink, ReactiveKafkaConsumer consumer) {
        super(vertx, configuration.config().getOptionalValue("default.api.timeout.ms", Integer.class).orElse(60000));
        this.channel = channel;
        this.vertx = vertx;
        this.configuration = configuration;
        this.retryTopics = retryTopics;
        this.maxRetries = maxRetries;
        this.retryTimeout = retryTimeout;
        this.deadQueueTopic = deadQueueTopic;
        this.dlqSource = dlqSource;
        this.dlqSink = dlqSink;
        this.consumer = consumer;
    }

    public static String getRetryTopic(String topic, int delayMillis) {
        return String.format("%s_retry_%d", topic, delayMillis);
    }

    private static String getMirrorSerializer(String deserializer) {
        if (deserializer == null) {
            return StringSerializer.class.getName();
        }
        return deserializer.replace("Deserializer", "Serializer");
    }

    private String getThrowableMessage(Throwable throwable) {
        String text = throwable.getMessage();
        if (text == null) {
            text = throwable.toString();
        }
        return text;
    }

    public Multi<? extends IncomingKafkaRecord<?, ?>> retryStream() {
        KafkaLatestCommit latestCommit = new KafkaLatestCommit(this.vertx, this.configuration, this.consumer);
        this.consumer.setRebalanceListener(null, latestCommit);
        Multi subscribe = this.consumer.subscribe(new HashSet<String>(this.retryTopics));
        latestCommit.capture(this.getContext());
        return subscribe.onItem().transform(record -> new IncomingKafkaRecord(record, this.channel, -1, latestCommit, this, this.configuration.getCloudEvents(), this.configuration.getTracingEnabled())).onItem().transformToUni(record -> {
            KafkaDelayedRetryTopic.incrementRetryHeader(record.getHeaders());
            Duration between = KafkaDelayedRetryTopic.getDelay(record);
            if (between.isNegative()) {
                return Uni.createFrom().item(record);
            }
            return Uni.createFrom().item(record).onItem().delayIt().by(between);
        }).concatenate(false);
    }

    @Override
    public <K, V> Uni<Void> handle(IncomingKafkaRecord<K, V> record, Throwable reason, Metadata metadata) {
        int delayFromTopic;
        OutgoingKafkaRecordMetadata outgoing = metadata != null ? (OutgoingKafkaRecordMetadata)metadata.get(OutgoingKafkaRecordMetadata.class).orElse(null) : null;
        KafkaDelayedRetryTopic.setOriginalTimestampHeader(record);
        KafkaDelayedRetryTopic.setFirstProcessingTimestampHeader(record);
        int retryCount = KafkaDelayedRetryTopic.setAndGetRetryHeader(record.getHeaders());
        String topic = KafkaDelayedRetryTopic.getNextTopic(this.retryTopics, this.deadQueueTopic, this.maxRetries, retryCount);
        if (!Objects.equals(topic, this.deadQueueTopic) && this.retryWillTimeout(record, this.retryTimeout, delayFromTopic = KafkaDelayedRetryTopic.getDelayFromTopic(topic))) {
            KafkaLogging.log.delayedRetryTimeout(this.channel, this.retryTimeout, KafkaDelayedRetryTopic.recordToString(record));
            topic = this.deadQueueTopic;
        }
        if (outgoing != null && outgoing.getTopic() != null) {
            topic = outgoing.getTopic();
        }
        Object key = record.getKey();
        if (outgoing != null && outgoing.getKey() != null) {
            key = outgoing.getKey();
        }
        int partition = record.getPartition();
        if (outgoing != null && outgoing.getPartition() >= 0) {
            partition = outgoing.getPartition();
        }
        if (topic == null) {
            KafkaLogging.log.delayedRetryNoDlq(this.channel);
            return Uni.createFrom().completionStage(record.ack()).emitOn(arg_0 -> record.runOnMessageContext(arg_0));
        }
        ProducerRecord retry = new ProducerRecord(topic, Integer.valueOf(partition), key, record.getPayload());
        this.addHeader(retry, DELAYED_RETRY_EXCEPTION_CLASS_NAME, reason.getClass().getName());
        this.addHeader(retry, DELAYED_RETRY_REASON, this.getThrowableMessage(reason));
        if (reason.getCause() != null) {
            this.addHeader(retry, DELAYED_RETRY_CAUSE_CLASS_NAME, reason.getCause().getClass().getName());
            this.addHeader(retry, DELAYED_RETRY_CAUSE, this.getThrowableMessage(reason.getCause()));
        }
        this.addHeader(retry, "delayed-retry-topic", record.getTopic());
        this.addHeader(retry, DELAYED_RETRY_PARTITION, Integer.toString(record.getPartition()));
        this.addHeader(retry, DELAYED_RETRY_OFFSET, Long.toString(record.getOffset()));
        record.getHeaders().forEach(header -> retry.headers().add(header));
        if (outgoing != null && outgoing.getHeaders() != null) {
            outgoing.getHeaders().forEach(header -> retry.headers().add(header));
        }
        retry.headers().remove("deserialization-failure-dlq");
        KafkaLogging.log.delayedRetryNack(this.channel, topic);
        CompletableFuture future = new CompletableFuture();
        this.dlqSource.onNext((Object)record.withPayload(retry).withAck(() -> record.ack().thenAccept(__ -> future.complete(null))).withNack(throwable -> {
            future.completeExceptionally((Throwable)throwable);
            return future;
        }));
        return Uni.createFrom().completionStage(future).emitOn(arg_0 -> record.runOnMessageContext(arg_0));
    }

    private boolean retryWillTimeout(IncomingKafkaRecord<?, ?> record, long retryTimeout, int delayFromTopic) {
        Instant nextRetry = Instant.now().plus((long)delayFromTopic, ChronoUnit.MILLIS);
        Instant firstProcessingTs = KafkaDelayedRetryTopic.getFirstProcessingTimestamp(record);
        return Duration.between(firstProcessingTs, nextRetry).toMillis() > retryTimeout;
    }

    void addHeader(ProducerRecord<?, ?> record, String key, String value) {
        KafkaDelayedRetryTopic.replaceHeader(record.headers(), key, value);
    }

    private static Instant getTimestampHeader(Headers headers, String key, long timestamp) {
        Header retry = headers.lastHeader(key);
        long epoch = retry == null ? timestamp : Long.parseLong(new String(retry.value()));
        return Instant.ofEpochMilli(epoch);
    }

    private static void setTimestampHeader(Headers headers, String key, long timestamp) {
        Header retry = headers.lastHeader(key);
        if (retry == null) {
            headers.add(key, Long.toString(timestamp).getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public void terminate() {
        this.dlqSink.closeQuietly();
        this.consumer.close();
    }

    private static Duration getDelay(IncomingKafkaRecord<?, ?> retried) {
        int delay = KafkaDelayedRetryTopic.getDelayFromTopic(retried.getTopic());
        return Duration.between(Instant.now(), retried.getTimestamp().plus((long)delay, ChronoUnit.MILLIS));
    }

    public static String getNextTopic(List<String> topics, String deadQueueTopic, int maxRetries, int retryCount) {
        int max;
        int n = max = maxRetries <= 0 ? topics.size() : maxRetries;
        if (retryCount < max) {
            return topics.get(Math.min(retryCount, topics.size() - 1));
        }
        return deadQueueTopic;
    }

    public static int getRetryHeader(Headers headers) {
        Header retry = headers.lastHeader(DELAYED_RETRY_COUNT);
        return retry == null ? 0 : Integer.parseInt(new String(retry.value()));
    }

    private static void incrementRetryHeader(Headers headers) {
        int count = KafkaDelayedRetryTopic.getRetryHeader(headers) + 1;
        KafkaDelayedRetryTopic.replaceHeader(headers, DELAYED_RETRY_COUNT, Integer.toString(count));
    }

    private static int setAndGetRetryHeader(Headers headers) {
        int count = KafkaDelayedRetryTopic.getRetryHeader(headers);
        if (count == 0) {
            KafkaDelayedRetryTopic.replaceHeader(headers, DELAYED_RETRY_COUNT, Integer.toString(count));
        }
        return count;
    }

    private static void setOriginalTimestampHeader(IncomingKafkaRecord<?, ?> record) {
        KafkaDelayedRetryTopic.setTimestampHeader(record.getHeaders(), DELAYED_RETRY_ORIGINAL_TIMESTAMP, record.getTimestamp().toEpochMilli());
    }

    private static Instant getFirstProcessingTimestamp(IncomingKafkaRecord<?, ?> record) {
        return KafkaDelayedRetryTopic.getTimestampHeader(record.getHeaders(), DELAYED_RETRY_FIRST_PROCESSING_TIMESTAMP, Instant.now().toEpochMilli());
    }

    private static void setFirstProcessingTimestampHeader(IncomingKafkaRecord<?, ?> record) {
        KafkaDelayedRetryTopic.setTimestampHeader(record.getHeaders(), DELAYED_RETRY_FIRST_PROCESSING_TIMESTAMP, Instant.now().toEpochMilli());
    }

    private static int getDelayFromTopic(String topicName) {
        return Integer.parseInt(topicName.substring(topicName.lastIndexOf("_") + 1));
    }

    private static String recordToString(IncomingKafkaRecord<?, ?> record) {
        return String.format("%s-%d:%d", record.getTopic(), record.getPartition(), record.getOffset());
    }

    private static void replaceHeader(Headers headers, String key, String value) {
        headers.remove(key);
        if (value != null) {
            headers.add(key, value.getBytes(StandardCharsets.UTF_8));
        }
    }

    @ApplicationScoped
    @Identifier(value="delayed-retry-topic")
    public static class Factory
    implements KafkaFailureHandler.Factory {
        @Inject
        KafkaCDIEvents kafkaCDIEvents;
        @Inject
        @Any
        Instance<DeserializationFailureHandler<?>> deserializationFailureHandlers;
        @Inject
        @Any
        Instance<ClientCustomizer<Map<String, Object>>> configCustomizers;
        @Inject
        @Any
        Instance<SerializationFailureHandler<?>> serializationFailureHandlers;
        @Inject
        @Any
        Instance<ProducerInterceptor<?, ?>> producerInterceptors;
        @Inject
        Instance<Config> rootConfig;
        @Inject
        @Any
        Instance<Map<String, Object>> configurations;
        @Inject
        Instance<OpenTelemetry> openTelemetryInstance;
        @Inject
        Instance<SubscriberDecorator> subscriberDecorators;

        @Override
        public KafkaFailureHandler create(KafkaConnectorIncomingConfiguration config, Vertx vertx, KafkaConsumer<?, ?> consumer, BiConsumer<Throwable, Boolean> reportFailure) {
            HashMap delayedRetryTopicProducerConfig = new HashMap(consumer.configuration());
            String keyDeserializer = (String)delayedRetryTopicProducerConfig.remove("key.deserializer");
            String valueDeserializer = (String)delayedRetryTopicProducerConfig.remove("value.deserializer");
            List retryTopics = config.getDelayedRetryTopicTopics().map(topics -> Arrays.stream(topics.split(",")).collect(Collectors.toList())).orElseGet(() -> Stream.of(KafkaDelayedRetryTopic.getRetryTopic(config.getChannel(), 10000), KafkaDelayedRetryTopic.getRetryTopic(config.getChannel(), 20000), KafkaDelayedRetryTopic.getRetryTopic(config.getChannel(), 50000)).collect(Collectors.toList()));
            int maxRetries = config.getDelayedRetryTopicMaxRetries().orElse(retryTopics.size());
            long retryTimeout = config.getDelayedRetryTopicTimeout().intValue();
            String deadQueueTopic = config.getDeadLetterQueueTopic().orElse(null);
            String consumerClientId = (String)consumer.configuration().get("client.id");
            OverrideConnectorConfig connectorConfig = new OverrideConnectorConfig("mp.messaging.incoming.", (Config)this.rootConfig.get(), "smallrye-kafka", config.getChannel(), "dead-letter-queue", Map.of("key.serializer", c -> KafkaDelayedRetryTopic.getMirrorSerializer(keyDeserializer), "value.serializer", c -> KafkaDelayedRetryTopic.getMirrorSerializer(valueDeserializer), "client.id", c -> config.getDeadLetterQueueProducerClientId().orElse("kafka-delayed-retry-topic-producer-" + consumerClientId), "topic", c -> retryTopics.get(0), "key-serialization-failure-handler", c -> "dlq-serialization", "value-serialization-failure-handler", c -> "dlq-serialization", "interceptor.classes", c -> ""));
            Config kafkaConfig = ConfigHelper.retrieveChannelConfiguration(this.configurations, (Config)connectorConfig);
            KafkaConnectorOutgoingConfiguration producerConfig = new KafkaConnectorOutgoingConfiguration(kafkaConfig);
            KafkaLogging.log.delayedRetryTopic(config.getChannel(), retryTopics, maxRetries, retryTimeout, deadQueueTopic);
            UnicastProcessor processor = UnicastProcessor.create();
            KafkaSink kafkaSink = new KafkaSink(producerConfig, this.kafkaCDIEvents, this.openTelemetryInstance, this.configCustomizers, this.serializationFailureHandlers, this.producerInterceptors);
            Wiring.wireOutgoingConnectorToUpstream((Multi)processor, kafkaSink.getSink(), this.subscriberDecorators, (String)(producerConfig.getChannel() + "-dead-letter-queue"));
            OverrideConnectorConfig retryConsumerConfig = new OverrideConnectorConfig("mp.messaging.incoming.", (Config)this.rootConfig.get(), "smallrye-kafka", config.getChannel(), "delayed-retry-topic.consumer", Map.of("lazy-client", c -> true, "client.id", c -> "kafka-delayed-retry-topic-" + consumerClientId, "group.id", c -> "kafka-delayed-retry-topic-" + consumerClientId));
            Config retryKafkaConfig = ConfigHelper.retrieveChannelConfiguration(this.configurations, (Config)retryConsumerConfig);
            KafkaConnectorIncomingConfiguration retryConfig = new KafkaConnectorIncomingConfiguration(retryKafkaConfig);
            ReactiveKafkaConsumer retryConsumer = new ReactiveKafkaConsumer(retryConfig, this.configCustomizers, this.deserializationFailureHandlers, (String)retryConsumerConfig.getValue("group.id", String.class), -1, reportFailure, (Context)((VertxInternal)vertx.getDelegate()).createEventLoopContext(), c -> this.kafkaCDIEvents.consumer().fire(c));
            return new KafkaDelayedRetryTopic(config.getChannel(), vertx, config, retryTopics, maxRetries, retryTimeout, deadQueueTopic, processor, kafkaSink, retryConsumer);
        }
    }
}

