/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.batch.jberet.BatchResourceDescriptionResolver;
import org.wildfly.extension.batch.jberet.deployment.JobOperationReadOnlyStepHandler;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobOperator;

public class BatchJobResourceDefinition
extends SimpleResourceDefinition {
    static final String JOB = "job";
    private static final SimpleAttributeDefinition RUNNING_EXECUTIONS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"running-executions", (ModelType)ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition INSTANCE_COUNT = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"instance-count", (ModelType)ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition JOB_XML_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"job-xml-name", (ModelType)ModelType.STRING).setStorageRuntime()).build();
    private static final SimpleListAttributeDefinition JOB_XML_NAMES = ((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"job-xml-names", (AttributeDefinition)JOB_XML_NAME).setStorageRuntime()).build();

    public BatchJobResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)JOB), (ResourceDescriptionResolver)BatchResourceDescriptionResolver.getResourceDescriptionResolver("deployment", JOB)).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)RUNNING_EXECUTIONS, (OperationStepHandler)new JobOperationReadOnlyStepHandler(){

            @Override
            protected void updateModel(OperationContext context, ModelNode model, WildFlyJobOperator jobOperator, String jobName) throws OperationFailedException {
                model.set(jobOperator.allowMissingJob(() -> jobOperator.getRunningExecutions(jobName).size(), 0).intValue());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)INSTANCE_COUNT, (OperationStepHandler)new JobOperationReadOnlyStepHandler(){

            @Override
            protected void updateModel(OperationContext context, ModelNode model, WildFlyJobOperator jobOperator, String jobName) throws OperationFailedException {
                model.set(jobOperator.allowMissingJob(() -> jobOperator.getJobInstanceCount(jobName), 0).intValue());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)JOB_XML_NAMES, (OperationStepHandler)new JobOperationReadOnlyStepHandler(){

            @Override
            protected void updateModel(OperationContext context, ModelNode model, WildFlyJobOperator jobOperator, String jobName) throws OperationFailedException {
                ModelNode list = model.setEmptyList();
                for (String jobXmlName : jobOperator.getJobXmlNames(jobName)) {
                    list.add(jobXmlName);
                }
            }
        });
    }
}

