/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemModel;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CacheResourceRegistration implements ResourceRegistration
{
    LOCAL("local-cache", CacheMode.LOCAL),
    INVALIDATION("invalidation-cache", CacheMode.INVALIDATION_SYNC),
    REPLICATED("replicated-cache", CacheMode.REPL_SYNC),
    DISTRIBUTED("distributed-cache", CacheMode.DIST_SYNC),
    SCATTERED("scattered-cache", CacheMode.DIST_SYNC){

        @Override
        InfinispanSubsystemModel getDeprecation() {
            return InfinispanSubsystemModel.VERSION_16_0_0;
        }
    };

    private final PathElement path;
    private final CacheMode mode;

    private CacheResourceRegistration(String key, CacheMode mode) {
        this.path = PathElement.pathElement((String)key);
        this.mode = mode;
    }

    public PathElement getPathElement() {
        return this.path;
    }

    CacheMode getCacheMode() {
        return this.mode;
    }

    InfinispanSubsystemModel getDeprecation() {
        return null;
    }

    PathElement pathElement(String name) {
        return PathElement.pathElement((String)this.path.getKey(), (String)name);
    }
}

