/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.api;

import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import io.smallrye.opentelemetry.api.SecuritySupport;
import java.security.AccessController;
import java.util.function.Function;

public class OpenTelemetryBuilderGetter
implements Function<OpenTelemetryConfig, AutoConfiguredOpenTelemetrySdkBuilder> {
    @Override
    public AutoConfiguredOpenTelemetrySdkBuilder apply(OpenTelemetryConfig config) {
        AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder();
        ClassLoader contextClassLoader = SecuritySupport.getContextClassLoader();
        if (contextClassLoader != null) {
            builder.setServiceClassLoader(contextClassLoader);
        }
        if (System.getSecurityManager() == null) {
            return this.getOpenTelemetryBuilder(builder, config);
        }
        return AccessController.doPrivileged(() -> this.getOpenTelemetryBuilder(builder, config));
    }

    private AutoConfiguredOpenTelemetrySdkBuilder getOpenTelemetryBuilder(AutoConfiguredOpenTelemetrySdkBuilder builder, OpenTelemetryConfig config) {
        return builder.addPropertiesSupplier(config::properties);
    }
}

