/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.ServiceLoader;
import org.jboss.as.ee.concurrent.ConcurrencyImplementation;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

class ConcurrencyImplementationLoader {
    private ConcurrencyImplementationLoader() {
    }

    static ConcurrencyImplementation load() {
        try {
            Module module;
            ModuleLoader moduleLoader = Module.getCallerModuleLoader();
            if (moduleLoader != null && (module = moduleLoader.loadModule("org.wildfly.concurrency")) != null) {
                return ConcurrencyImplementationLoader.load((ClassLoader)module.getClassLoader());
            }
            return ConcurrencyImplementationLoader.load(Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable e) {
            throw EeLogger.ROOT_LOGGER.failedToLoadConcurrencyImplementation(e);
        }
    }

    static ConcurrencyImplementation load(ClassLoader classLoader) {
        ConcurrencyImplementation concurrencyImplementation = ServiceLoader.load(ConcurrencyImplementation.class, classLoader).findFirst().get();
        EeLogger.ROOT_LOGGER.debugf("Jakarta Concurrency Implementation '%s' loaded.", concurrencyImplementation);
        return concurrencyImplementation;
    }
}

