/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.faces.mojarra.util;

import com.sun.faces.util.LRUMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LRUMapMarshaller
extends AbstractMapMarshaller<Object, Object, LRUMap<Object, Object>> {
    private static final int MAX_CAPACITY_INDEX = 2;
    private static final int DEFAULT_MAX_CAPACITY = 15;
    private static final Field MAX_CAPACITY_FIELD = (Field)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            for (Field field : LRUMap.class.getDeclaredFields()) {
                if (field.getType() != Integer.TYPE) continue;
                field.setAccessible(true);
                return field;
            }
            throw new IllegalStateException();
        }
    });

    public LRUMapMarshaller() {
        super(LRUMap.class);
    }

    public LRUMap<Object, Object> readFrom(ProtoStreamReader reader) throws IOException {
        int maxCapacity = 15;
        LinkedList<Map.Entry> entries = new LinkedList<Map.Entry>();
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    entries.add((Map.Entry)reader.readObject(AbstractMap.SimpleEntry.class));
                    continue block4;
                }
                case 2: {
                    maxCapacity = reader.readUInt32();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        LRUMap map = new LRUMap(maxCapacity);
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void writeTo(ProtoStreamWriter writer, LRUMap<Object, Object> map) throws IOException {
        super.writeTo(writer, map);
        try {
            int maxCapacity = MAX_CAPACITY_FIELD.getInt(map);
            if (maxCapacity != 15) {
                writer.writeUInt32(2, maxCapacity);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

