/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Weigher;
import java.util.OptionalLong;
import java.util.function.BiPredicate;
import org.wildfly.clustering.cache.caffeine.CacheConfiguration;
import org.wildfly.clustering.function.Function;

public class CacheFactory<K, V>
implements Function<CacheConfiguration<K, V>, Cache<K, V>> {
    private static final Expiry<Object, Object> NEVER = new Expiry<Object, Object>(){

        public long expireAfterCreate(Object key, Object value, long currentTime) {
            return Long.MAX_VALUE;
        }

        public long expireAfterUpdate(Object key, Object value, long currentTime, long currentDuration) {
            return currentDuration;
        }

        public long expireAfterRead(Object key, Object value, long currentTime, long currentDuration) {
            return currentDuration;
        }
    };

    static <K, V> Expiry<K, V> never() {
        return NEVER;
    }

    public Cache<K, V> apply(CacheConfiguration<K, V> configuration) {
        OptionalLong maxWeight;
        Caffeine builder = Caffeine.newBuilder().executor(Runnable::run);
        final Expiry expiry = configuration.getExpiry();
        final Weigher<K, V> weigher = configuration.getWeigher();
        if (expiry != NEVER) {
            builder.expireAfter(weigher != Weigher.singletonWeigher() ? new Expiry<K, V>(){
                private final BiPredicate<K, V> expirable = new BiPredicate<K, V>(){

                    @Override
                    public boolean test(K key, V value) {
                        return weigher.weigh(key, value) > 0;
                    }
                };

                public long expireAfterCreate(K key, V value, long currentTime) {
                    return this.expirable.test(key, value) ? expiry.expireAfterCreate(key, value, currentTime) : Long.MAX_VALUE;
                }

                public long expireAfterUpdate(K key, V value, long currentTime, long currentDuration) {
                    return this.expirable.test(key, value) ? expiry.expireAfterUpdate(key, value, currentTime, currentDuration) : currentDuration;
                }

                public long expireAfterRead(K key, V value, long currentTime, long currentDuration) {
                    return this.expirable.test(key, value) ? expiry.expireAfterRead(key, value, currentTime, currentDuration) : currentDuration;
                }
            } : expiry).scheduler(configuration.getScheduler());
        }
        if ((maxWeight = configuration.getMaxWeight()).isPresent()) {
            if (weigher == Weigher.singletonWeigher()) {
                builder.maximumSize(maxWeight.getAsLong());
            } else {
                builder.maximumWeight(maxWeight.getAsLong()).weigher(weigher);
            }
        }
        configuration.getEvictionListener().ifPresent(arg_0 -> ((Caffeine)builder).evictionListener(arg_0));
        configuration.getRemovalListener().ifPresent(arg_0 -> ((Caffeine)builder).removalListener(arg_0));
        return builder.build();
    }
}

