/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.impl;

import io.smallrye.stork.api.LoadBalancer;
import io.smallrye.stork.api.ServiceDiscovery;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.impl.RoundRobinConfiguration;
import io.smallrye.stork.impl.RoundRobinLoadBalancerProvider;
import io.smallrye.stork.spi.internal.LoadBalancerLoader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class RoundRobinLoadBalancerProviderLoader
implements LoadBalancerLoader {
    private final RoundRobinLoadBalancerProvider provider;

    public RoundRobinLoadBalancerProviderLoader() {
        RoundRobinLoadBalancerProvider actual = null;
        try {
            actual = (RoundRobinLoadBalancerProvider)CDI.current().select(RoundRobinLoadBalancerProvider.class, new Annotation[0]).get();
        }
        catch (Exception e) {
            actual = new RoundRobinLoadBalancerProvider();
        }
        this.provider = actual;
    }

    public LoadBalancer createLoadBalancer(ConfigWithType config, ServiceDiscovery serviceDiscovery) {
        RoundRobinConfiguration typedConfig = new RoundRobinConfiguration(config.parameters());
        return this.provider.createLoadBalancer(typedConfig, serviceDiscovery);
    }

    public String type() {
        return "round-robin";
    }
}

