/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.integration;

import io.smallrye.stork.spi.StorkInfrastructure;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class DefaultStorkInfrastructure
implements StorkInfrastructure {
    private final Map<Class<?>, Object> utilities = new ConcurrentHashMap();

    public <T> T get(Class<T> utilityClass, Supplier<T> defaultSupplier) {
        Objects.requireNonNull(utilityClass, "utilityClass cannot be null");
        Objects.requireNonNull(defaultSupplier, "defaultSupplier cannot be null");
        return (T)this.utilities.computeIfAbsent(utilityClass, key -> defaultSupplier.get());
    }
}

