/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.utils;

import java.time.Duration;
import java.util.regex.Pattern;

public class DurationUtils {
    private static final Pattern DIGITS = Pattern.compile("^[-+]?\\d+$");

    private DurationUtils() {
    }

    public static Duration parseDuration(String duration, String parameter) {
        if (duration.startsWith("-")) {
            throw new IllegalArgumentException("Negative " + parameter + " specified for service discovery: " + duration);
        }
        if (DIGITS.asPredicate().test(duration)) {
            return Duration.ofSeconds(Long.parseLong(duration));
        }
        return Duration.parse("PT" + duration);
    }
}

