/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.io.PrintWriter;
import java.util.Objects;

class AnnotatedConstructor {
    private final String className;
    private final String descriptor;

    AnnotatedConstructor(String className, String descriptor) {
        this.className = className;
        this.descriptor = descriptor;
    }

    void save(PrintWriter writer, String separator) {
        writer.println(this.className + separator + this.descriptor);
    }

    static AnnotatedConstructor parseReadLine(String s, String separator) {
        String[] arr = s.split(separator);
        if (arr.length != 2) {
            throw new IllegalArgumentException(s);
        }
        return new AnnotatedConstructor(arr[0], arr[1]);
    }

    String getClassName() {
        return this.className;
    }

    String getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotatedConstructor)) {
            return false;
        }
        AnnotatedConstructor that = (AnnotatedConstructor)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.descriptor);
    }
}

