/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.index;

import java.io.PrintWriter;
import java.util.Objects;

class AnnotatedField {
    private final String className;
    private final String fieldName;

    AnnotatedField(String className, String fieldName) {
        this.className = className;
        this.fieldName = fieldName;
    }

    static AnnotatedField parseReadLine(String s, String separator) {
        String[] arr = s.split(separator);
        if (arr.length != 2) {
            throw new IllegalArgumentException(s);
        }
        return new AnnotatedField(arr[0], arr[1]);
    }

    String getClassName() {
        return this.className;
    }

    String getFieldName() {
        return this.fieldName;
    }

    void save(PrintWriter writer, String separator) {
        writer.println(this.className + separator + this.fieldName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotatedField)) {
            return false;
        }
        AnnotatedField that = (AnnotatedField)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.fieldName);
    }
}

