/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.operations.AbstractNoCacheHotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.logging.Log;

abstract class BaseCounterOperation<T>
extends AbstractNoCacheHotRodOperation<T> {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final String counterName;
    private final boolean useConsistentHash;

    BaseCounterOperation(String counterName, boolean useConsistentHash) {
        this.counterName = counterName;
        this.useConsistentHash = useConsistentHash;
    }

    @Override
    public String getCacheName() {
        return "org.infinispan.COUNTER";
    }

    @Override
    public byte[] getCacheNameBytes() {
        return RemoteCacheManager.cacheNameBytes("org.infinispan.COUNTER");
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        ByteBufUtil.writeString(buf, this.counterName);
    }

    void checkStatus(short status) {
        if (status == 2) {
            throw Log.HOTROD.undefinedCounter(this.counterName);
        }
    }

    @Override
    public Object getRoutingObject() {
        return this.useConsistentHash ? new ByteString(this.counterName) : null;
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append("counter=").append(this.counterName);
    }

    private static class ByteString {
        private final int hash;
        private final byte[] b;

        private ByteString(String s) {
            this.b = s.getBytes(CHARSET);
            this.hash = Arrays.hashCode(this.b);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteString that = (ByteString)o;
            return Arrays.equals(this.b, that.b);
        }

        public String toString() {
            return new String(this.b, CHARSET);
        }
    }
}

