/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.jsp.tagext.FunctionInfo;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jasper.JasperException;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagFileProcessor;

class ImplicitTagLibraryInfo
extends TagLibraryInfo {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    private static final String TAG_FILE_SUFFIX = ".tag";
    private static final String TAGX_FILE_SUFFIX = ".tagx";
    private static final String TAGS_SHORTNAME = "tags";
    private static final String TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "2.0";
    private static final String IMPLICIT_TLD = "implicit.tld";
    private final Hashtable<String, String> tagFileMap;
    private final ParserController pc;
    private final PageInfo pi;
    private final Vector<TagFileInfo> vec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImplicitTagLibraryInfo(JspCompilationContext ctxt, ParserController pc, PageInfo pi, String prefix, String tagdir, ErrorDispatcher err) throws JasperException {
        super(prefix, null);
        this.pc = pc;
        this.pi = pi;
        this.tagFileMap = new Hashtable();
        this.vec = new Vector();
        this.functions = new FunctionInfo[0];
        this.tlibversion = TLIB_VERSION;
        this.jspversion = JSP_VERSION;
        if (!tagdir.startsWith(WEB_INF_TAGS)) {
            err.jspError(JasperMessages.MESSAGES.invalidTagFileDirectory(tagdir), new String[0]);
        }
        if (tagdir.equals(WEB_INF_TAGS) || tagdir.equals("/WEB-INF/tags/")) {
            this.shortname = TAGS_SHORTNAME;
        } else {
            this.shortname = tagdir.substring(WEB_INF_TAGS.length());
            this.shortname = this.shortname.replace('/', '-');
        }
        Set<String> dirList = ctxt.getResourcePaths(tagdir);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith(TAG_FILE_SUFFIX) || path.endsWith(TAGX_FILE_SUFFIX)) {
                    String suffix = path.endsWith(TAG_FILE_SUFFIX) ? TAG_FILE_SUFFIX : TAGX_FILE_SUFFIX;
                    String tagName = path.substring(path.lastIndexOf("/") + 1);
                    tagName = tagName.substring(0, tagName.lastIndexOf(suffix));
                    this.tagFileMap.put(tagName, path);
                    continue;
                }
                if (!path.endsWith(IMPLICIT_TLD)) continue;
                InputStream is = null;
                try {
                    is = ctxt.getResourceAsStream(path);
                    if (is == null) continue;
                    if (pi != null) {
                        pi.addDependant(path, ctxt.getLastModified(path));
                    }
                    XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(is);
                    reader.require(7, null, null);
                    while (reader.hasNext() && reader.next() != 1) {
                    }
                    int count = reader.getAttributeCount();
                    for (int i = 0; i < count; ++i) {
                        if (!"version".equals(reader.getAttributeLocalName(i))) continue;
                        this.jspversion = reader.getAttributeValue(i);
                    }
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        String elementName = reader.getLocalName();
                        if ("tlibversion".equals(elementName) || "tlib-version".equals(elementName)) {
                            this.tlibversion = reader.getElementText().trim();
                            continue;
                        }
                        if ("jspversion".equals(elementName) || "jsp-version".equals(elementName)) {
                            this.jspversion = reader.getElementText().trim();
                            continue;
                        }
                        if ("shortname".equals(elementName) || "short-name".equals(elementName)) {
                            reader.getElementText();
                            continue;
                        }
                        err.jspError(JasperMessages.MESSAGES.invalidImplicitTld(path), new String[0]);
                    }
                    try {
                        double version = Double.parseDouble(this.jspversion);
                        if (!(version < 2.0)) continue;
                        err.jspError(JasperMessages.MESSAGES.invalidImplicitTldVersion(path), new String[0]);
                    }
                    catch (NumberFormatException e) {
                        err.jspError(JasperMessages.MESSAGES.invalidImplicitTldVersion(path), new String[0]);
                    }
                }
                catch (XMLStreamException e) {
                    err.jspError(e, JasperMessages.MESSAGES.invalidImplicitTld(path), new String[0]);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public TagFileInfo getTagFile(String shortName) {
        TagFileInfo tagFile = super.getTagFile(shortName);
        if (tagFile == null) {
            String path = this.tagFileMap.get(shortName);
            if (path == null) {
                return null;
            }
            TagInfo tagInfo = null;
            try {
                tagInfo = TagFileProcessor.parseTagFileDirectives(this.pc, shortName, path, null, this);
            }
            catch (JasperException je) {
                throw new RuntimeException(je.toString(), (Throwable)((Object)je));
            }
            tagFile = new TagFileInfo(shortName, path, tagInfo);
            this.vec.addElement(tagFile);
            this.tagFiles = new TagFileInfo[this.vec.size()];
            this.vec.copyInto(this.tagFiles);
        }
        return tagFile;
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> coll = this.pi.getTaglibs();
        return coll.toArray(new TagLibraryInfo[0]);
    }
}

