/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.xml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.as.controller.FeatureRegistry;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLContentWriter;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementReader;
import org.jboss.as.controller.xml.XMLParticle;
import org.jboss.as.version.Stability;

public interface XMLElementGroup<RC, WC>
extends XMLParticle<RC, WC> {
    public Set<QName> getReaderNames();

    default public Collection<QName> getNames() {
        return this.getReaderNames();
    }

    public static class DefaultXMLElementGroup<RC, WC>
    extends XMLParticle.DefaultXMLParticle<RC, WC>
    implements XMLElementGroup<RC, WC> {
        private final Set<QName> names;

        private static <RC, WC> Stability maxStability(Collection<? extends XMLParticle<RC, WC>> particles) {
            Stability maxStability = null;
            for (XMLParticle<RC, WC> particle : particles) {
                Stability particleStability = particle.getStability();
                if (maxStability != null && particleStability.enables(maxStability)) continue;
                maxStability = particleStability;
            }
            return maxStability != null ? maxStability : Stability.DEFAULT;
        }

        protected DefaultXMLElementGroup(Set<QName> names, Collection<? extends XMLParticle<RC, WC>> particles, XMLCardinality cardinality, XMLElementReader<RC> reader) {
            this(names, cardinality, reader, XMLContentWriter.composite(particles), DefaultXMLElementGroup.maxStability(particles));
        }

        protected DefaultXMLElementGroup(Set<QName> names, XMLCardinality cardinality, XMLElementReader<RC> reader, XMLContentWriter<WC> writer, Stability stability) {
            super(cardinality, reader, writer, stability);
            this.names = names;
        }

        @Override
        public Set<QName> getReaderNames() {
            return this.names;
        }

        public int hashCode() {
            return this.getNames().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof XMLElementGroup)) {
                return false;
            }
            XMLElementGroup group = (XMLElementGroup)object;
            return this.getNames().equals(group.getNames());
        }

        public String toString() {
            return this.getNames().toString();
        }
    }

    public static abstract class AbstractBuilder<RC, WC, E extends XMLElement<RC, WC>, T extends XMLElementGroup<RC, WC>, B extends Builder<RC, WC, E, T, B>>
    extends XMLParticle.AbstractBuilder<RC, WC, T, B>
    implements Builder<RC, WC, E, T, B>,
    FeatureRegistry {
        private final List<E> elements = new LinkedList();
        private final FeatureRegistry registry;

        protected AbstractBuilder(FeatureRegistry registry) {
            this.registry = registry;
        }

        @Override
        public Stability getStability() {
            return this.registry.getStability();
        }

        @Override
        public B addElement(E element) {
            if (this.enables(element) && element.getCardinality().isEnabled()) {
                this.elements.add(element);
            }
            return (B)((Builder)this.builder());
        }

        protected List<E> getElements() {
            return this.elements;
        }
    }

    public static interface Builder<RC, WC, E extends XMLElement<RC, WC>, T extends XMLElementGroup<RC, WC>, B extends Builder<RC, WC, E, T, B>>
    extends XMLParticle.Builder<RC, WC, T, B> {
        public B addElement(E var1);
    }
}

