/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.CommonAttributes;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanCpuTimeHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-thread-cpu-time", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setParameters(new AttributeDefinition[]{CommonAttributes.ID}).setReplyType(ModelType.LONG).setRuntimeOnly().setReadOnly().build();
    public static final ThreadMXBeanCpuTimeHandler INSTANCE = new ThreadMXBeanCpuTimeHandler();
    private final ParametersValidator validator = new ParametersValidator();

    private ThreadMXBeanCpuTimeHandler() {
        this.validator.registerValidator("id", LongRangeValidator.POSITIVE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        try {
            long id = operation.require("id").asLong();
            context.getResult().set(ManagementFactory.getThreadMXBean().getThreadCpuTime(id));
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(e.toString());
        }
    }
}

