/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.CommonAttributes;
import org.jboss.as.platform.mbean.ExtendedThreadMBean;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanThreadAllocatedBytesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("get-thread-allocated-bytes", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setParameters(new AttributeDefinition[]{CommonAttributes.ID}).setReplyType(ModelType.LONG).setRuntimeOnly().setReadOnly().setStability(Stability.COMMUNITY).build();
    public static final ThreadMXBeanThreadAllocatedBytesHandler INSTANCE = new ThreadMXBeanThreadAllocatedBytesHandler();
    private final ParametersValidator idValidator = new ParametersValidator();

    private ThreadMXBeanThreadAllocatedBytesHandler() {
        this.idValidator.registerValidator("id", LongRangeValidator.POSITIVE);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.idValidator.validate(operation);
        ExtendedThreadMBean mbean = new ExtendedThreadMBean();
        if (mbean.isOperationDefined("getThreadAllocatedBytes", new String[]{Long.TYPE.getName()})) {
            try {
                long id = operation.require("id").asLong();
                context.getResult().set(mbean.getThreadAllocatedBytes(id));
            }
            catch (UnsupportedOperationException e) {
                throw new OperationFailedException(e.toString());
            }
        } else {
            throw PlatformMBeanLogger.ROOT_LOGGER.unsupportedOperation("get-thread-cpu-times");
        }
    }
}

