/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.util.function.SerializablePredicate;
import org.wildfly.clustering.cache.CacheEntryLocator;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.Locality;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.IntervalTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.ScheduleTimeoutCommand;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCacheEntryFilter;
import org.wildfly.clustering.ejb.infinispan.timer.TimerCacheKeyFilter;
import org.wildfly.clustering.ejb.infinispan.timer.TimerTask;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimeoutMetaData;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.dispatcher.CacheContainerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.manager.AffinityIdentifierFactoryService;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntriesTask;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntrySchedulerService;
import org.wildfly.clustering.server.infinispan.scheduler.CacheKeysTask;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerCommand;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerService;
import org.wildfly.clustering.server.local.scheduler.LocalSchedulerService;
import org.wildfly.clustering.server.local.scheduler.ScheduledEntries;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.scheduler.SchedulerService;
import org.wildfly.security.manager.WildFlySecurityManager;

public class InfinispanTimerManager<I, C>
implements TimerManager<I> {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(InfinispanTimerManager.class, WildFlySecurityManager.getClassLoaderPrivileged(InfinispanTimerManager.class));
    private final Cache<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>> cache;
    private final TimerFactory<I, RemappableTimerMetaDataEntry<C>> factory;
    private final Marshaller<Object, C> marshaller;
    private final IdentifierFactoryService<I> identifierFactory;
    private final org.wildfly.clustering.function.Supplier<Batch> batchFactory;
    private final SchedulerService<I, TimeoutMetaData> scheduler;

    public InfinispanTimerManager(final InfinispanTimerManagerConfiguration<I, C> config) {
        Cache cache;
        this.cache = cache = config.getCache();
        this.marshaller = config.getMarshaller();
        this.identifierFactory = new AffinityIdentifierFactoryService((Supplier)config.getIdentifierFactory(), this.cache);
        this.batchFactory = config.getBatchFactory();
        this.factory = config.getTimerFactory();
        final TimerRegistry<I> registry = config.getRegistry();
        final CacheContainerCommandDispatcherFactory dispatcherFactory = config.getCommandDispatcherFactory();
        CacheContainerGroup group = dispatcherFactory.getGroup();
        final AtomicReference<4> reference = new AtomicReference<4>();
        final ScheduledEntries entries = ScheduledEntries.sorted();
        final TimerTask task = new TimerTask(new TimerTask.Configuration<I, RemappableTimerMetaDataEntry<C>>(){

            @Override
            public TimerFactory<I, RemappableTimerMetaDataEntry<C>> getTimerFactory() {
                return config.getTimerFactory();
            }

            @Override
            public TimerManager<I> getTimerManager() {
                return InfinispanTimerManager.this;
            }

            @Override
            public Locality getLocality() {
                return Locality.forCurrentConsistentHash((Cache)config.getCache());
            }

            @Override
            public Scheduler<I, TimeoutMetaData> getScheduler() {
                return (Scheduler)reference.get();
            }

            @Override
            public ScheduledEntries<I, Instant> getScheduledEntries() {
                return entries;
            }

            @Override
            public TimerRegistry<I> getTimerRegistry() {
                return registry;
            }
        });
        LocalSchedulerService localScheduler = new LocalSchedulerService<I>(new LocalSchedulerService.Configuration<I>(){

            public String getName() {
                return config.getName();
            }

            public ScheduledEntries<I, Instant> getScheduledEntries() {
                return entries;
            }

            public Predicate<I> getTask() {
                return task;
            }

            public ThreadFactory getThreadFactory() {
                return THREAD_FACTORY;
            }

            public Duration getCloseTimeout() {
                return config.getStopTimeout();
            }
        }){

            public void schedule(I id, Instant instant) {
                super.schedule(id, instant);
                registry.register(id);
            }

            public void cancel(I id) {
                registry.unregister(id);
                super.cancel(id);
            }

            public void close() {
                task.close();
                super.close();
            }
        };
        TimerMetaDataFactory metaDataFactory = config.getTimerFactory().getMetaDataFactory();
        final CacheEntrySchedulerService cacheEntryScheduler = new CacheEntrySchedulerService<I, TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>, TimeoutMetaData>(localScheduler.compose(Function.identity(), TimeoutMetaData::getNextTimeout), (BiFunction)org.wildfly.clustering.function.BiFunction.applyLatter(arg_0 -> ((TimerMetaDataFactory)metaDataFactory).createImmutableTimerMetaData(arg_0))){

            public void start() {
                super.start();
                CacheEntriesTask.schedule((Cache)cache, TimerCacheEntryFilter.META_DATA_ENTRY.cast(), (CacheEntryScheduler)this).accept((Object)CacheStreamFilter.local((Cache)cache));
            }
        };
        reference.set(cacheEntryScheduler);
        Object object = this.scheduler = !group.isSingleton() ? new PrimaryOwnerSchedulerService(new PrimaryOwnerSchedulerService.Configuration<I, TimeoutMetaData, Map.Entry<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>>, TimerMetaDataKey<I>>(){

            public EmbeddedCacheConfiguration getCacheConfiguration() {
                return config;
            }

            public CacheContainerCommandDispatcherFactory getCommandDispatcherFactory() {
                return dispatcherFactory;
            }

            public SchedulerService<I, TimeoutMetaData> getScheduler() {
                return cacheEntryScheduler;
            }

            public Function<Map.Entry<I, TimeoutMetaData>, PrimaryOwnerCommand<I, TimeoutMetaData, Void>> getScheduleCommandFactory() {
                return ScheduleTimeoutCommand::new;
            }

            public Consumer<CacheStreamFilter<TimerMetaDataKey<I>>> getCancelTask() {
                return CacheKeysTask.cancel((Cache)cache, (Predicate)((Object)TimerCacheKeyFilter.META_DATA_KEY), (CacheEntryScheduler)cacheEntryScheduler);
            }

            public Consumer<CacheStreamFilter<Map.Entry<TimerMetaDataKey<I>, RemappableTimerMetaDataEntry<C>>>> getScheduleTask() {
                return CacheEntriesTask.schedule((Cache)cache, TimerCacheEntryFilter.META_DATA_ENTRY.cast(), (CacheEntryScheduler)cacheEntryScheduler);
            }
        }) : cacheEntryScheduler;
        if (config.isActive()) {
            this.identifierFactory.start();
        }
    }

    public boolean isStarted() {
        return this.scheduler.isStarted();
    }

    public void start() {
        if (!this.identifierFactory.isStarted()) {
            this.identifierFactory.start();
        }
        this.scheduler.start();
    }

    public void stop() {
        this.scheduler.stop();
        this.identifierFactory.stop();
    }

    public void close() {
        this.scheduler.close();
        if (this.identifierFactory.isStarted()) {
            this.identifierFactory.stop();
        }
    }

    public Timer<I> createTimer(I id, IntervalTimerConfiguration config, Object context) {
        try {
            IntervalTimerMetaDataEntry entry = new IntervalTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context, Method method, int index) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config, method);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, new TimerIndex(method, index));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Timer<I> createTimer(I id, RemappableTimerMetaDataEntry<C> entry, TimerIndex index) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        if (metaDataFactory.createValue(id, new AbstractMap.SimpleImmutableEntry<RemappableTimerMetaDataEntry<C>, TimerIndex>(entry, index)) == null) {
            return null;
        }
        ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(entry);
        Timer timer = this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduler);
        return timer;
    }

    public Timer<I> getTimer(I id) {
        return this.findTimer(CacheEntryLocator::findValue, id);
    }

    public Timer<I> readTimer(I id) {
        return this.findTimer(CacheEntryLocator::tryValue, id);
    }

    private Timer<I> findTimer(org.wildfly.clustering.function.BiFunction<ImmutableTimerMetaDataFactory<I, RemappableTimerMetaDataEntry<C>>, I, RemappableTimerMetaDataEntry<C>> finder, I id) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        RemappableTimerMetaDataEntry entry = (RemappableTimerMetaDataEntry)finder.apply((Object)metaDataFactory, id);
        if (entry != null) {
            ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData((Object)entry);
            return this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduler);
        }
        return null;
    }

    public Stream<I> getActiveTimers() {
        return this.cache.keySet().stream().filter((SerializablePredicate)TimerCacheKeyFilter.META_DATA_KEY).map(Key::getId);
    }

    public org.wildfly.clustering.function.Supplier<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public org.wildfly.clustering.function.Supplier<Batch> getBatchFactory() {
        return this.batchFactory;
    }

    public String toString() {
        return this.cache.getName();
    }
}

