/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.services.framework.task;

import com.arjuna.services.framework.task.Task;
import com.arjuna.services.framework.task.TaskWorker;
import com.arjuna.webservices.logging.WSCLogger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class TaskManager {
    private static final TaskManager MANAGER = new TaskManager();
    private static final int DEFAULT_MAXIMUM_THREAD_COUNT = 10;
    private static final int DEFAULT_MINIMUM_THREAD_COUNT = 0;
    private int minimumWorkerCount = 0;
    private int maximumWorkerCount = 10;
    private Set workerPool = new HashSet();
    private LinkedList taskList = new LinkedList();
    private int taskCount;
    private int waitingCount;
    private boolean shutdown;

    public static TaskManager getManager() {
        return MANAGER;
    }

    private TaskManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queueTask(Task task) {
        boolean create;
        boolean notify;
        boolean debugEnabled = WSCLogger.logger.isTraceEnabled();
        Set set = this.workerPool;
        synchronized (set) {
            if (this.shutdown) {
                if (debugEnabled) {
                    WSCLogger.logger.tracef("Shutdown in progress, ignoring task '%s'", (Object)task);
                }
                return false;
            }
        }
        LinkedList linkedList = this.taskList;
        synchronized (linkedList) {
            this.taskList.addLast(task);
            boolean bl = notify = this.waitingCount > 0;
            if (notify) {
                if (debugEnabled) {
                    WSCLogger.logger.tracef("queueTask: notifying waiting workers (%s) for task '%s'", (Object)this.waitingCount, (Object)task);
                }
                this.taskList.notify();
            }
        }
        Set set2 = this.workerPool;
        synchronized (set2) {
            create = this.workerPool.size() < this.minimumWorkerCount || this.workerPool.size() < this.maximumWorkerCount && !notify;
        }
        if (create) {
            if (debugEnabled) {
                WSCLogger.logger.tracef("queueTask: creating worker for task '%s'", (Object)task);
            }
            this.createWorker();
        } else if (debugEnabled) {
            WSCLogger.logger.tracef("queueTask: queueing task '%s' for execution", (Object)task);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumWorkerCount(int minimumWorkerCount) {
        boolean debugEnabled = WSCLogger.logger.isTraceEnabled();
        Set set = this.workerPool;
        synchronized (set) {
            if (this.shutdown) {
                if (debugEnabled) {
                    WSCLogger.logger.tracev("shutdown in progress, ignoring set minimum worker count", new Object[0]);
                }
                return;
            }
            int n = this.minimumWorkerCount = minimumWorkerCount < 0 ? 0 : minimumWorkerCount;
            if (this.minimumWorkerCount > this.maximumWorkerCount) {
                this.maximumWorkerCount = this.minimumWorkerCount;
            }
            if (debugEnabled) {
                WSCLogger.logger.tracev("setMinimumWorkerCount: {0}", new Object[0]);
            }
        }
        while (true) {
            boolean create;
            Set set2 = this.workerPool;
            synchronized (set2) {
                create = this.workerPool.size() < this.minimumWorkerCount;
            }
            if (!create) break;
            this.createWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumWorkerCount() {
        Set set = this.workerPool;
        synchronized (set) {
            return this.minimumWorkerCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumWorkerCount(int maximumWorkerCount) {
        boolean debugEnabled = WSCLogger.logger.isTraceEnabled();
        Set set = this.workerPool;
        synchronized (set) {
            if (this.shutdown) {
                if (debugEnabled) {
                    WSCLogger.logger.tracev("shutdown in progress, ignoring set maximum worker count", new Object[0]);
                }
                return;
            }
            int n = this.maximumWorkerCount = maximumWorkerCount < 0 ? 10 : maximumWorkerCount;
            if (this.minimumWorkerCount > this.maximumWorkerCount) {
                this.minimumWorkerCount = this.maximumWorkerCount;
            }
            if (debugEnabled) {
                WSCLogger.logger.tracev("setMaximumWorkerCount: {0}", new Object[]{this.maximumWorkerCount});
            }
            LinkedList linkedList = this.taskList;
            synchronized (linkedList) {
                if (this.workerPool.size() > this.maximumWorkerCount && this.waitingCount > 0) {
                    if (debugEnabled) {
                        WSCLogger.logger.tracev("setMaximumWorkerCount: reducing pool size from {0} to {1}", new Object[]{this.workerPool.size(), this.maximumWorkerCount});
                    }
                    this.taskList.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumWorkerCount() {
        Set set = this.workerPool;
        synchronized (set) {
            return this.maximumWorkerCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkerCount() {
        Set set = this.workerPool;
        synchronized (set) {
            return this.workerPool.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        boolean debugEnabled = WSCLogger.logger.isTraceEnabled();
        Set set = this.workerPool;
        synchronized (set) {
            if (this.shutdown) {
                if (debugEnabled) {
                    WSCLogger.logger.tracev("Shutdown already in progress", new Object[0]);
                }
            } else {
                this.setMaximumWorkerCount(0);
                this.shutdown = true;
            }
        }
        while (true) {
            Thread waitThread;
            Set set2 = this.workerPool;
            synchronized (set2) {
                Iterator workerPoolIter = this.workerPool.iterator();
                waitThread = workerPoolIter.hasNext() ? (Thread)workerPoolIter.next() : null;
            }
            if (waitThread == null) break;
            try {
                waitThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        set = this.workerPool;
        synchronized (set) {
            if (this.shutdown) {
                this.taskList.clear();
                this.shutdown = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task getTask() {
        boolean debugEnabled = WSCLogger.logger.isTraceEnabled();
        while (true) {
            boolean remove;
            Collection collection = this.workerPool;
            synchronized (collection) {
                int excessCount = this.workerPool.size() - this.maximumWorkerCount;
                if (excessCount > 0) {
                    if (debugEnabled) {
                        WSCLogger.logger.tracev("getTask: releasing thread", new Object[0]);
                    }
                    LinkedList linkedList = this.taskList;
                    synchronized (linkedList) {
                        if (excessCount > 1 && this.waitingCount > 0) {
                            if (debugEnabled) {
                                WSCLogger.logger.tracev("getTask: notifying waiting thread about excess count {0}", new Object[]{excessCount});
                            }
                            this.taskList.notify();
                        }
                    }
                    remove = true;
                } else {
                    remove = false;
                }
            }
            if (remove) {
                Thread currentThread = Thread.currentThread();
                Set excessCount = this.workerPool;
                synchronized (excessCount) {
                    this.workerPool.remove(currentThread);
                }
                return null;
            }
            collection = this.taskList;
            synchronized (collection) {
                int numTasks = this.taskList.size();
                if (numTasks > 0) {
                    Task task = (Task)this.taskList.removeFirst();
                    if (numTasks > 1 && this.waitingCount > 0) {
                        this.taskList.notify();
                    }
                    if (debugEnabled) {
                        WSCLogger.logger.tracev("getTask: returning task {0}", (Object)task);
                    }
                    return task;
                }
                ++this.waitingCount;
                if (debugEnabled) {
                    WSCLogger.logger.tracev("getTask: waiting for task for {0} number of times", (Object)this.waitingCount);
                }
                try {
                    this.taskList.wait();
                }
                catch (InterruptedException ie) {
                    if (debugEnabled) {
                        WSCLogger.logger.tracev("getTask: interrupted", new Object[0]);
                    }
                }
                finally {
                    --this.waitingCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWorker() {
        String name;
        TaskWorker taskWorker = new TaskWorker(this);
        Set set = this.workerPool;
        synchronized (set) {
            name = "TaskWorker-" + ++this.taskCount;
        }
        Thread thread = new Thread((Runnable)taskWorker, name);
        thread.setDaemon(true);
        Set set2 = this.workerPool;
        synchronized (set2) {
            this.workerPool.add(thread);
        }
        thread.start();
    }
}

