/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsarjtx.client;

import com.arjuna.schemas.ws._2005._10.wsarjtx.NotificationType;
import com.arjuna.schemas.ws._2005._10.wsarjtx.TerminationCoordinatorRPCPortType;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.client.WSARJTXClient;
import jakarta.xml.ws.soap.SOAPFaultException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import java.io.IOException;
import org.jboss.ws.api.addressing.MAP;

public class TerminationCoordinatorRPCClient {
    private static final TerminationCoordinatorRPCClient CLIENT = new TerminationCoordinatorRPCClient();
    private String completeAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Complete";
    private String closeAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Close";
    private String cancelAction = "http://schemas.arjuna.com/ws/2005/10/wsarjtx/Cancel";

    private TerminationCoordinatorRPCClient() {
    }

    public void sendComplete(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault11, IOException {
        TerminationCoordinatorRPCPortType port = this.getPort(coordinator, map, this.completeAction);
        NotificationType complete = new NotificationType();
        try {
            port.completeOperation(complete);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public void sendClose(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault11, IOException {
        TerminationCoordinatorRPCPortType port = this.getPort(coordinator, map, this.closeAction);
        NotificationType close = new NotificationType();
        try {
            port.closeOperation(close);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public void sendCancel(W3CEndpointReference coordinator, MAP map, InstanceIdentifier identifier) throws SoapFault11, IOException {
        TerminationCoordinatorRPCPortType port = this.getPort(coordinator, map, this.cancelAction);
        NotificationType cancel = new NotificationType();
        try {
            port.cancelOperation(cancel);
        }
        catch (SOAPFaultException sfe) {
            throw SoapFault11.create(sfe);
        }
    }

    public static TerminationCoordinatorRPCClient getClient() {
        return CLIENT;
    }

    private TerminationCoordinatorRPCPortType getPort(W3CEndpointReference endpoint, MAP map, String action) {
        return WSARJTXClient.getTerminationCoordinatorRPCPort(endpoint, action, map);
    }
}

