/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.OptionalInt;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Formatter;

public interface Serializer<T> {
    public void write(DataOutput var1, T var2) throws IOException;

    public T read(DataInput var1) throws IOException;

    default public OptionalInt size(T object) {
        return OptionalInt.empty();
    }

    default public <V> Serializer<V> wrap(final Function<V, T> unwrapper, final Function<T, V> wrapper) {
        final Serializer serializer = this;
        return new Serializer<V>(){

            @Override
            public void write(DataOutput output, V value) throws IOException {
                serializer.write(output, unwrapper.apply(value));
            }

            @Override
            public V read(DataInput input) throws IOException {
                return wrapper.apply(serializer.read(input));
            }

            @Override
            public OptionalInt size(V object) {
                return serializer.size(unwrapper.apply(object));
            }
        };
    }

    default public Formatter<T> toFormatter(final Class<? extends T> type) {
        final Serializer serializer = this;
        return new Formatter<T>(){

            @Override
            public Class<? extends T> getType() {
                return type;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T parse(String value) {
                byte[] bytes = Base64.getDecoder().decode(value);
                try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));){
                    Object t = serializer.read(input);
                    return t;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public String format(T key) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(serializer.size(key).orElse(64));
                try (DataOutputStream output = new DataOutputStream(bytes);){
                    serializer.write(output, key);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                return Base64.getEncoder().encodeToString(bytes.toByteArray());
            }
        };
    }

    public static <T> Serializer<T> of(final T value) {
        return new Serializer<T>(){

            @Override
            public void write(DataOutput output, T value2) throws IOException {
            }

            @Override
            public T read(DataInput input) throws IOException {
                return value;
            }
        };
    }

    public static class Provided<T>
    implements Serializer<T> {
        private final Serializer<T> serializer;

        public Provided(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        public void write(DataOutput output, T value) throws IOException {
            this.serializer.write(output, value);
        }

        @Override
        public T read(DataInput input) throws IOException {
            return this.serializer.read(input);
        }

        @Override
        public OptionalInt size(T object) {
            return this.serializer.size(object);
        }

        @Override
        public <V> Serializer<V> wrap(Function<V, T> unwrapper, Function<T, V> wrapper) {
            return this.serializer.wrap(unwrapper, wrapper);
        }
    }
}

